/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.plugin.control.tps.barrier;

import com.alibaba.nacos.plugin.control.tps.barrier.RateCounter;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;

public class LocalSimpleCountRateCounter
extends RateCounter {
    private static final int DEFAULT_RECORD_SIZE = 10;
    long startTime = System.currentTimeMillis();
    private List<TpsSlot> slotList = new ArrayList<TpsSlot>(10);

    public LocalSimpleCountRateCounter(String name, TimeUnit period) {
        super(name, period);
        for (int i = 0; i < 10; ++i) {
            this.slotList.add(new TpsSlot());
        }
        long now = System.currentTimeMillis();
        this.startTime = period == TimeUnit.SECONDS ? RateCounter.getTrimMillsOfSecond(now) : (period == TimeUnit.MINUTES ? RateCounter.getTrimMillsOfMinute(now) : (period == TimeUnit.HOURS ? RateCounter.getTrimMillsOfHour(now) : RateCounter.getTrimMillsOfSecond(now)));
    }

    @Override
    public long add(long timestamp, long count) {
        return ((TpsSlot)this.createSlotIfAbsent((long)timestamp)).countHolder.count.addAndGet(count);
    }

    @Override
    public boolean tryAdd(long timestamp, long countDelta, long upperLimit) {
        if (((TpsSlot)this.createSlotIfAbsent((long)timestamp)).countHolder.count.addAndGet(countDelta) <= upperLimit) {
            return true;
        }
        ((TpsSlot)this.createSlotIfAbsent((long)timestamp)).countHolder.interceptedCount.addAndGet(countDelta);
        return false;
    }

    public void minus(long timestamp, long count) {
        AtomicLong currentCount = ((TpsSlot)this.createSlotIfAbsent((long)timestamp)).countHolder.count;
        currentCount.addAndGet(count * -1L);
    }

    @Override
    public long getCount(long timestamp) {
        TpsSlot point = this.getPoint(timestamp);
        return point == null ? 0L : ((TpsSlot)point).countHolder.count.longValue();
    }

    private TpsSlot getPoint(long timeStamp) {
        long distance = timeStamp - this.startTime;
        long diff = (distance < 0L ? distance + this.getPeriod().toMillis(1L) * 10L : distance) / this.getPeriod().toMillis(1L);
        long currentWindowTime = this.startTime + diff * this.getPeriod().toMillis(1L);
        int index = (int)diff % 10;
        TpsSlot tpsSlot = this.slotList.get(index);
        if (tpsSlot.time != currentWindowTime) {
            return null;
        }
        return tpsSlot;
    }

    public TpsSlot createSlotIfAbsent(long timeStamp) {
        long distance = timeStamp - this.startTime;
        long diff = (distance < 0L ? distance + this.getPeriod().toMillis(1L) * 10L : distance) / this.getPeriod().toMillis(1L);
        long currentWindowTime = this.startTime + diff * this.getPeriod().toMillis(1L);
        int index = (int)diff % 10;
        TpsSlot tpsSlot = this.slotList.get(index);
        if (tpsSlot.time != currentWindowTime) {
            tpsSlot.reset(currentWindowTime);
        }
        return this.slotList.get(index);
    }

    static class SlotCountHolder {
        AtomicLong count = new AtomicLong();
        AtomicLong interceptedCount = new AtomicLong();

        SlotCountHolder() {
        }

        public String toString() {
            return "{" + this.count + "|" + this.interceptedCount + '}';
        }
    }

    static class TpsSlot {
        long time = 0L;
        private SlotCountHolder countHolder = new SlotCountHolder();

        TpsSlot() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void reset(long second) {
            TpsSlot tpsSlot = this;
            synchronized (tpsSlot) {
                if (this.time != second) {
                    this.time = second;
                    this.countHolder.count.set(0L);
                    this.countHolder.interceptedCount.set(0L);
                }
            }
        }

        public String toString() {
            return "TpsSlot{time=" + this.time + ", countHolder=" + this.countHolder + '}';
        }
    }
}

