/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.api.naming.pojo.healthcheck;

import com.alibaba.nacos.api.exception.runtime.NacosDeserializationException;
import com.alibaba.nacos.api.exception.runtime.NacosSerializationException;
import com.alibaba.nacos.api.naming.pojo.healthcheck.AbstractHealthChecker;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.jsontype.NamedType;
import java.io.IOException;

public class HealthCheckerFactory {
    private static final ObjectMapper MAPPER = new ObjectMapper();

    public static void registerSubType(AbstractHealthChecker extendHealthChecker) {
        HealthCheckerFactory.registerSubType(extendHealthChecker.getClass(), extendHealthChecker.getType());
    }

    public static void registerSubType(Class<? extends AbstractHealthChecker> extendHealthCheckerClass, String typeName) {
        MAPPER.registerSubtypes(new NamedType[]{new NamedType(extendHealthCheckerClass, typeName)});
    }

    public static AbstractHealthChecker.None createNoneHealthChecker() {
        return new AbstractHealthChecker.None();
    }

    public static AbstractHealthChecker deserialize(String jsonString) {
        try {
            return (AbstractHealthChecker)MAPPER.readValue(jsonString, AbstractHealthChecker.class);
        }
        catch (IOException e) {
            throw new NacosDeserializationException(AbstractHealthChecker.class, (Throwable)e);
        }
    }

    public static String serialize(AbstractHealthChecker healthChecker) {
        try {
            return MAPPER.writeValueAsString((Object)healthChecker);
        }
        catch (JsonProcessingException e) {
            throw new NacosSerializationException(healthChecker.getClass(), (Throwable)e);
        }
    }

    static {
        MAPPER.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
    }
}

