/*
 * Decompiled with CFR 0.152.
 */
package org.jeasy.random.validation;

import java.lang.reflect.Field;
import java.math.BigDecimal;
import javax.validation.constraints.DecimalMax;
import javax.validation.constraints.DecimalMin;
import org.jeasy.random.api.Randomizer;
import org.jeasy.random.util.ReflectionUtils;
import org.jeasy.random.validation.AbstractNumberBaseAnnotationHandler;

class DecimalMinMaxAnnotationHandler
extends AbstractNumberBaseAnnotationHandler {
    DecimalMinMaxAnnotationHandler(long seed) {
        super(seed);
    }

    @Override
    public Randomizer<?> getRandomizer(Field field) {
        Class<?> fieldType = field.getType();
        DecimalMax decimalMaxAnnotation = (DecimalMax)ReflectionUtils.getAnnotation((Field)field, DecimalMax.class);
        DecimalMin decimalMinAnnotation = (DecimalMin)ReflectionUtils.getAnnotation((Field)field, DecimalMin.class);
        BigDecimal maxValue = null;
        BigDecimal minValue = null;
        if (decimalMaxAnnotation != null) {
            maxValue = new BigDecimal(decimalMaxAnnotation.value());
        }
        if (decimalMinAnnotation != null) {
            minValue = new BigDecimal(decimalMinAnnotation.value());
        }
        return this.getRandomizer(fieldType, minValue, maxValue);
    }
}

