/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.sqlobject.locator;

import java.lang.reflect.Method;
import java.util.function.Function;
import org.jdbi.v3.core.config.ConfigRegistry;
import org.jdbi.v3.core.locator.ClasspathSqlLocator;
import org.jdbi.v3.sqlobject.internal.SqlAnnotations;
import org.jdbi.v3.sqlobject.locator.SqlLocator;

public class SqlObjectClasspathSqlLocator
implements SqlLocator {
    @Override
    public String locate(Class<?> sqlObjectType, Method method, ConfigRegistry config) {
        Function<String, String> valueOrMethodNameToSql = key -> {
            String filename = key.isEmpty() ? method.getName() : key;
            return ClasspathSqlLocator.findSqlOnClasspath((Class)sqlObjectType, (String)filename);
        };
        return SqlAnnotations.getAnnotationValue(method, valueOrMethodNameToSql).orElseThrow(() -> new IllegalStateException(String.format("method %s has no query annotations", method)));
    }
}

