/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.sqlobject.transaction.internal;

import java.lang.reflect.Method;
import org.jdbi.v3.core.Handle;
import org.jdbi.v3.core.HandleCallback;
import org.jdbi.v3.core.transaction.TransactionException;
import org.jdbi.v3.core.transaction.TransactionIsolationLevel;
import org.jdbi.v3.sqlobject.Handler;
import org.jdbi.v3.sqlobject.HandlerDecorator;
import org.jdbi.v3.sqlobject.transaction.Transaction;

public class TransactionDecorator
implements HandlerDecorator {
    @Override
    public Handler decorateHandler(Handler base, Class<?> sqlObjectType, Method method) {
        Transaction txnAnnotation = method.getAnnotation(Transaction.class);
        TransactionIsolationLevel isolation = txnAnnotation.value();
        boolean readOnly = txnAnnotation.readOnly();
        return (target, args, handle) -> {
            Object object;
            block7: {
                boolean flipReadOnly;
                Handle h = handle.getHandle();
                if (h.isInTransaction()) {
                    TransactionIsolationLevel currentLevel = h.getTransactionIsolationLevel();
                    if (currentLevel != isolation && isolation != TransactionIsolationLevel.UNKNOWN) {
                        throw new TransactionException("Tried to execute nested @Transaction(" + isolation + "), but already running in a transaction with isolation level " + currentLevel + ".");
                    }
                    if (h.isReadOnly() && !readOnly) {
                        throw new TransactionException("Tried to execute a nested @Transaction(readOnly=false) inside a readOnly transaction");
                    }
                    return base.invoke(target, args, handle);
                }
                HandleCallback callback = th -> base.invoke(target, args, handle);
                boolean bl = flipReadOnly = readOnly != h.isReadOnly();
                if (flipReadOnly) {
                    h.setReadOnly(readOnly);
                }
                try {
                    object = h.inTransaction(isolation, callback);
                    if (!flipReadOnly) break block7;
                    h.setReadOnly(!readOnly);
                }
                catch (Throwable throwable) {
                    if (flipReadOnly) {
                        h.setReadOnly(!readOnly);
                    }
                    throw throwable;
                }
            }
            return object;
        };
    }
}

