/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.sqlobject.config;

import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.function.Consumer;
import org.jdbi.v3.core.config.ConfigRegistry;
import org.jdbi.v3.core.mapper.RowMapperFactory;
import org.jdbi.v3.core.mapper.RowMappers;
import org.jdbi.v3.core.mapper.reflect.ConstructorMapper;
import org.jdbi.v3.sqlobject.config.ConfigurerFactory;
import org.jdbi.v3.sqlobject.config.ConfiguringAnnotation;

@ConfiguringAnnotation(value=Factory.class)
@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.TYPE, ElementType.METHOD})
public @interface RegisterConstructorMapper {
    public Class<?>[] value();

    public String[] prefix() default {};

    public static class Factory
    implements ConfigurerFactory {
        @Override
        public Consumer<ConfigRegistry> createForMethod(Annotation annotation, Class<?> sqlObjectType, Method method) {
            return this.create((RegisterConstructorMapper)annotation);
        }

        @Override
        public Consumer<ConfigRegistry> createForType(Annotation annotation, Class<?> sqlObjectType) {
            return this.create((RegisterConstructorMapper)annotation);
        }

        private Consumer<ConfigRegistry> create(RegisterConstructorMapper rcm) {
            Class<?>[] types = rcm.value();
            String[] prefixes = rcm.prefix();
            ArrayList<RowMapperFactory> mappers = new ArrayList<RowMapperFactory>(types.length);
            if (prefixes.length == 0) {
                for (Class<?> type : types) {
                    mappers.add(ConstructorMapper.of(type));
                }
            } else if (prefixes.length == types.length) {
                for (int i = 0; i < types.length; ++i) {
                    mappers.add(ConstructorMapper.of(types[i], (String)prefixes[i]));
                }
            } else {
                throw new IllegalStateException("RegisterConstructorMapper.prefix() must have the same number of elements as value()");
            }
            return config -> mappers.forEach(arg_0 -> ((RowMappers)((RowMappers)config.get(RowMappers.class))).register(arg_0));
        }
    }
}

