/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.sqlobject;

import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collector;
import java.util.stream.Stream;
import org.jdbi.v3.core.Query;
import org.jdbi.v3.core.ResultBearing;
import org.jdbi.v3.core.StatementContext;
import org.jdbi.v3.core.exception.UnableToCreateStatementException;
import org.jdbi.v3.core.mapper.RowMapper;
import org.jdbi.v3.core.util.GenericTypes;
import org.jdbi.v3.sqlobject.DefaultGeneratedKeyMapper;
import org.jdbi.v3.sqlobject.GetGeneratedKeys;
import org.jdbi.v3.sqlobject.SingleValue;
import org.jdbi.v3.sqlobject.customizers.UseRowMapper;

abstract class ResultReturner {
    ResultReturner() {
    }

    public Object map(Method method, Query<?> q) {
        if (method.isAnnotationPresent(UseRowMapper.class)) {
            RowMapper<?> mapper;
            try {
                mapper = method.getAnnotation(UseRowMapper.class).value().newInstance();
            }
            catch (Exception e) {
                throw new UnableToCreateStatementException("unable to access mapper", (Throwable)e, null);
            }
            return this.result((ResultBearing<?>)q.map(mapper));
        }
        return this.result((ResultBearing<?>)q.mapTo(this.elementType(q.getContext())));
    }

    static ResultReturner forOptionalReturn(Class<?> extensionType, Method method) {
        if (method.getReturnType() == Void.TYPE) {
            return new ResultReturner(){

                @Override
                protected Object result(ResultBearing<?> bearer) {
                    bearer.stream().forEach(i -> {});
                    return null;
                }

                @Override
                protected Type elementType(StatementContext ctx) {
                    return null;
                }
            };
        }
        return ResultReturner.forMethod(extensionType, method);
    }

    static ResultReturner forMethod(Class<?> extensionType, Method method) {
        Type returnType = GenericTypes.resolveType((Type)method.getGenericReturnType(), extensionType);
        Class returnClass = GenericTypes.getErasedType((Type)returnType);
        if (Void.TYPE.equals(returnClass)) {
            throw new IllegalStateException(String.format("Method %s#%s is annotated as if it should return a value, but the method is void.", method.getDeclaringClass().getName(), method.getName()));
        }
        if (ResultBearing.class.isAssignableFrom(returnClass)) {
            return new ResultBearingResultReturner(returnType);
        }
        if (Stream.class.isAssignableFrom(returnClass)) {
            return new StreamReturner(returnType);
        }
        if (Iterator.class.isAssignableFrom(returnClass)) {
            return new IteratorResultReturner(returnType);
        }
        if (method.isAnnotationPresent(SingleValue.class)) {
            return new SingleValueResultReturner(returnType);
        }
        if (returnClass.isArray()) {
            return new ArrayResultReturner(returnClass.getComponentType());
        }
        return new DefaultResultReturner(method, returnType);
    }

    protected abstract Object result(ResultBearing<?> var1);

    static RowMapper<?> rowMapperFor(GetGeneratedKeys ggk, Type returnType) {
        if (DefaultGeneratedKeyMapper.class.equals(ggk.value())) {
            return new DefaultGeneratedKeyMapper(returnType, ggk.columnName());
        }
        try {
            return ggk.value().getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new UnableToCreateStatementException("Unable to instantiate row mapper for statement", (Throwable)e, null);
        }
    }

    protected abstract Type elementType(StatementContext var1);

    static class ArrayResultReturner
    extends ResultReturner {
        private final Class<?> componentType;

        ArrayResultReturner(Class<?> componentType) {
            this.componentType = componentType;
        }

        @Override
        protected Object result(ResultBearing<?> bearer) {
            List list = bearer.list();
            Object result = Array.newInstance(this.componentType, list.size());
            for (int i = 0; i < list.size(); ++i) {
                Array.set(result, i, list.get(i));
            }
            return result;
        }

        @Override
        protected Type elementType(StatementContext ctx) {
            return this.componentType;
        }
    }

    static class IteratorResultReturner
    extends ResultReturner {
        private final Type elementType;

        IteratorResultReturner(Type returnType) {
            this.elementType = (Type)GenericTypes.findGenericParameter((Type)returnType, Iterator.class).orElseThrow(() -> new IllegalStateException("Cannot reflect Iterator<T> element type T in method return type " + returnType));
        }

        @Override
        protected Object result(ResultBearing<?> bearer) {
            return bearer.iterator();
        }

        @Override
        protected Type elementType(StatementContext ctx) {
            return this.elementType;
        }
    }

    static class ResultBearingResultReturner
    extends ResultReturner {
        private final Type elementType;

        ResultBearingResultReturner(Type returnType) {
            this.elementType = (Type)GenericTypes.findGenericParameter((Type)returnType, Query.class).orElseThrow(() -> new IllegalStateException("Cannot reflect Query<T> element type T in method return type " + returnType));
        }

        @Override
        protected Object result(ResultBearing<?> bearer) {
            return bearer;
        }

        @Override
        protected Type elementType(StatementContext ctx) {
            return this.elementType;
        }
    }

    static class SingleValueResultReturner
    extends ResultReturner {
        private final Type returnType;

        SingleValueResultReturner(Type returnType) {
            this.returnType = returnType;
        }

        @Override
        protected Object result(ResultBearing<?> bearer) {
            return bearer.findFirst().orElse(null);
        }

        @Override
        protected Type elementType(StatementContext ctx) {
            return this.returnType;
        }
    }

    static class DefaultResultReturner
    extends ResultReturner {
        private final Type returnType;

        DefaultResultReturner(Method method, Type returnType) {
            this.returnType = returnType;
        }

        @Override
        protected Object result(ResultBearing<?> bearer) {
            Collector collector = bearer.getContext().findCollectorFor(this.returnType).orElse(null);
            if (collector != null) {
                return bearer.collect(collector);
            }
            return bearer.findFirst().orElse(null);
        }

        @Override
        protected Type elementType(StatementContext ctx) {
            return ctx.findElementTypeFor(this.returnType).orElse(this.returnType);
        }
    }

    static class StreamReturner
    extends ResultReturner {
        private final Type elementType;

        StreamReturner(Type returnType) {
            this.elementType = (Type)GenericTypes.findGenericParameter((Type)returnType, Stream.class).orElseThrow(() -> new IllegalStateException("Cannot reflect Stream<T> element type T in method return type " + returnType));
        }

        @Override
        protected Stream<?> result(ResultBearing<?> bearer) {
            return bearer.stream();
        }

        @Override
        protected Type elementType(StatementContext ctx) {
            return this.elementType;
        }
    }
}

