/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.sqlobject;

import java.lang.reflect.Method;
import java.lang.reflect.Type;
import org.jdbi.v3.core.GeneratedKeys;
import org.jdbi.v3.core.HandleSupplier;
import org.jdbi.v3.core.ResultBearing;
import org.jdbi.v3.core.SqlStatement;
import org.jdbi.v3.core.Update;
import org.jdbi.v3.core.exception.UnableToCreateStatementException;
import org.jdbi.v3.core.util.GenericTypes;
import org.jdbi.v3.sqlobject.CustomizingStatementHandler;
import org.jdbi.v3.sqlobject.DefaultGeneratedKeyMapper;
import org.jdbi.v3.sqlobject.GetGeneratedKeys;
import org.jdbi.v3.sqlobject.ResultReturnThing;
import org.jdbi.v3.sqlobject.SqlObjectConfig;
import org.jdbi.v3.sqlobject.exceptions.UnableToCreateSqlObjectException;

class UpdateHandler
extends CustomizingStatementHandler {
    private final Class<?> sqlObjectType;
    private final Returner returner;

    UpdateHandler(Class<?> sqlObjectType, Method method) {
        super(sqlObjectType, method);
        this.sqlObjectType = sqlObjectType;
        boolean isGetGeneratedKeys = method.isAnnotationPresent(GetGeneratedKeys.class);
        Type returnType = GenericTypes.resolveType((Type)method.getGenericReturnType(), sqlObjectType);
        if (isGetGeneratedKeys) {
            DefaultGeneratedKeyMapper mapper;
            ResultReturnThing magic = ResultReturnThing.forMethod(sqlObjectType, method);
            GetGeneratedKeys ggk = method.getAnnotation(GetGeneratedKeys.class);
            if (DefaultGeneratedKeyMapper.class.equals(ggk.value())) {
                mapper = new DefaultGeneratedKeyMapper(returnType, ggk.columnName());
            } else {
                try {
                    mapper = ggk.value().newInstance();
                }
                catch (Exception e) {
                    throw new UnableToCreateStatementException("Unable to instantiate row mapper for statement", (Throwable)e, null);
                }
            }
            this.returner = (update, handle) -> {
                GeneratedKeys o = update.executeAndReturnGeneratedKeys(mapper, ggk.columnName());
                return magic.result((ResultBearing<?>)o, handle);
            };
        } else if (this.isNumeric(method.getReturnType())) {
            this.returner = (update, handle) -> update.execute();
        } else if (this.isBoolean(method.getReturnType())) {
            this.returner = (update, handle) -> update.execute() > 0;
        } else {
            throw new UnableToCreateSqlObjectException(this.invalidReturnTypeMessage(method, returnType));
        }
    }

    @Override
    public Object invoke(Object target, Method method, Object[] args, SqlObjectConfig config, HandleSupplier handle) {
        String sql = config.getSqlLocator().locate(this.sqlObjectType, method);
        Update q = handle.getHandle().createUpdate(sql);
        this.applyCustomizers((SqlStatement<?>)q, args);
        this.applyBinders((SqlStatement<?>)q, args);
        return this.returner.value(q, handle);
    }

    private boolean isNumeric(Class<?> type) {
        return Number.class.isAssignableFrom(type) || type.equals(Integer.TYPE) || type.equals(Long.TYPE) || type.equals(Void.TYPE);
    }

    private boolean isBoolean(Class<?> type) {
        return type.equals(Boolean.TYPE) || type.equals(Boolean.class);
    }

    private String invalidReturnTypeMessage(Method method, Type returnType) {
        return method.getDeclaringClass().getSimpleName() + "." + method.getName() + " method is annotated with @SqlUpdate so should return void, boolean, or Number but is returning: " + returnType;
    }

    private static interface Returner {
        public Object value(Update var1, HandleSupplier var2);
    }
}

