/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.sqlobject.customizers;

import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Method;
import org.jdbi.v3.sqlobject.SqlStatementCustomizer;
import org.jdbi.v3.sqlobject.SqlStatementCustomizerFactory;
import org.jdbi.v3.sqlobject.SqlStatementCustomizingAnnotation;
import org.jdbi.v3.statement.StatementCustomizer;
import org.jdbi.v3.statement.StatementCustomizers;

@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.METHOD, ElementType.PARAMETER, ElementType.TYPE})
@SqlStatementCustomizingAnnotation(value=Factory.class)
public @interface FetchDirection {
    public int value();

    public static class Factory
    implements SqlStatementCustomizerFactory {
        public SqlStatementCustomizer createForParameter(Annotation annotation, Object arg) {
            return Factory.create((Integer)arg);
        }

        @Override
        public SqlStatementCustomizer createForMethod(Annotation annotation, Class<?> sqlObjectType, Method method) {
            FetchDirection fs = (FetchDirection)annotation;
            return Factory.create(fs.value());
        }

        @Override
        public SqlStatementCustomizer createForType(Annotation annotation, Class<?> sqlObjectType) {
            FetchDirection fs = (FetchDirection)annotation;
            return Factory.create(fs.value());
        }

        @Override
        public SqlStatementCustomizer createForParameter(Annotation annotation, Class<?> sqlObjectType, Method method, Object arg) {
            return Factory.create((Integer)arg);
        }

        private static SqlStatementCustomizer create(Integer direction) {
            return q -> q.addStatementCustomizer((StatementCustomizer)new StatementCustomizers.FetchDirectionStatementCustomizer(direction));
        }
    }
}

