/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.sqlobject;

import java.lang.reflect.Method;
import java.util.function.Supplier;
import org.jdbi.v3.Handle;
import org.jdbi.v3.exception.TransactionException;
import org.jdbi.v3.sqlobject.Handler;
import org.jdbi.v3.sqlobject.PassThroughHandler;
import org.jdbi.v3.sqlobject.Transaction;
import org.jdbi.v3.transaction.TransactionCallback;
import org.jdbi.v3.transaction.TransactionIsolationLevel;

class PassThroughTransactionHandler
implements Handler {
    private final TransactionIsolationLevel isolation;
    private final PassThroughHandler delegate;

    PassThroughTransactionHandler(Transaction tx) {
        this.isolation = tx.value();
        this.delegate = new PassThroughHandler();
    }

    @Override
    public Object invoke(Supplier<Handle> handle, Object target, Object[] args, Method method) throws Exception {
        Handle h = handle.get();
        if (h.isInTransaction()) {
            throw new TransactionException("Nested @Transaction detected - this is currently not supported.");
        }
        TransactionCallback callback = (conn, status) -> this.delegate.invoke(handle, target, args, method);
        if (this.isolation == TransactionIsolationLevel.INVALID_LEVEL) {
            return h.inTransaction(callback);
        }
        return h.inTransaction(this.isolation, callback);
    }
}

