/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.postgres;

import java.io.InputStream;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.jdbi.v3.core.argument.AbstractArgumentFactory;
import org.jdbi.v3.core.argument.Argument;
import org.jdbi.v3.core.config.ConfigRegistry;
import org.jdbi.v3.core.statement.StatementContext;
import org.jdbi.v3.postgres.PgLobApi;
import org.jdbi.v3.postgres.PostgresTypes;

class BlobInputStreamArgumentFactory
extends AbstractArgumentFactory<InputStream> {
    BlobInputStreamArgumentFactory() {
        super(2004);
    }

    protected Argument build(InputStream value, ConfigRegistry config) {
        return new LobInputStreamArgument(value);
    }

    static class LobInputStreamArgument
    implements Argument {
        private final InputStream value;

        LobInputStreamArgument(InputStream value) {
            this.value = value;
        }

        public void apply(int pos, PreparedStatement stmt, StatementContext ctx) throws SQLException {
            PgLobApi lob = ((PostgresTypes)ctx.getConfig(PostgresTypes.class)).getLobApi();
            long oid = lob.createLob();
            lob.writeLob(oid, this.value);
            stmt.setLong(pos, oid);
        }
    }
}

