/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.postgres;

import java.lang.reflect.Type;
import java.time.Duration;
import java.util.Optional;
import org.jdbi.v3.core.config.ConfigRegistry;
import org.jdbi.v3.core.mapper.ColumnMapper;
import org.jdbi.v3.core.mapper.ColumnMapperFactory;
import org.postgresql.util.PGInterval;

public class DurationColumnMapperFactory
implements ColumnMapperFactory {
    public Optional<ColumnMapper<?>> build(Type type, ConfigRegistry config) {
        if (type != Duration.class) {
            return Optional.empty();
        }
        return Optional.of((r, i, c) -> {
            Object obj = r.getObject(i);
            if (obj == null) {
                return null;
            }
            if (!(obj instanceof PGInterval)) {
                throw new IllegalArgumentException(String.format("got non-pginterval %s", obj));
            }
            PGInterval interval = (PGInterval)obj;
            if (interval.getYears() != 0 || interval.getMonths() != 0) {
                throw new IllegalArgumentException(String.format("pginterval \"%s\" not representable as duration", interval.getValue()));
            }
            double seconds = interval.getSeconds();
            if (seconds > 9.223372036854776E18 || seconds < -9.223372036854776E18) {
                throw new IllegalArgumentException(String.format("pginterval \"%s\" has seconds too extreme to represent as duration", interval.getValue()));
            }
            long secondsLong = (long)seconds;
            long nanos = (long)((seconds - (double)secondsLong) * 1.0E9);
            return Duration.ofDays(interval.getDays()).plusHours(interval.getHours()).plusMinutes(interval.getMinutes()).plusSeconds(secondsLong).plusNanos(nanos);
        });
    }
}

