/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.postgres;

import java.util.Map;
import java.util.UUID;
import org.jdbi.v3.core.Handle;
import org.jdbi.v3.core.Jdbi;
import org.jdbi.v3.core.argument.ArgumentFactory;
import org.jdbi.v3.core.generic.GenericType;
import org.jdbi.v3.core.internal.JdbiClassUtils;
import org.jdbi.v3.core.internal.exceptions.Unchecked;
import org.jdbi.v3.core.mapper.ColumnMapper;
import org.jdbi.v3.core.mapper.ColumnMapperFactory;
import org.jdbi.v3.core.spi.JdbiPlugin;
import org.jdbi.v3.postgres.DurationArgumentFactory;
import org.jdbi.v3.postgres.DurationColumnMapperFactory;
import org.jdbi.v3.postgres.HStoreArgumentFactory;
import org.jdbi.v3.postgres.HStoreColumnMapper;
import org.jdbi.v3.postgres.InetArgumentFactory;
import org.jdbi.v3.postgres.JavaTimeArgumentFactory;
import org.jdbi.v3.postgres.JavaTimeMapperFactory;
import org.jdbi.v3.postgres.JsonArgumentFactory;
import org.jdbi.v3.postgres.MacAddrArgumentFactory;
import org.jdbi.v3.postgres.MacAddrColumnMapper;
import org.jdbi.v3.postgres.PGobjectArgumentFactory;
import org.jdbi.v3.postgres.PGobjectColumnMapperFactory;
import org.jdbi.v3.postgres.PeriodArgumentFactory;
import org.jdbi.v3.postgres.PeriodColumnMapperFactory;
import org.jdbi.v3.postgres.PostgresTypes;
import org.jdbi.v3.postgres.TypedEnumArgumentFactory;
import org.jdbi.v3.postgres.UUIDArgumentFactory;
import org.postgresql.PGConnection;
import org.postgresql.geometric.PGbox;
import org.postgresql.geometric.PGcircle;
import org.postgresql.geometric.PGline;
import org.postgresql.geometric.PGlseg;
import org.postgresql.geometric.PGpath;
import org.postgresql.geometric.PGpoint;
import org.postgresql.geometric.PGpolygon;
import org.postgresql.util.PGInterval;
import org.postgresql.util.PGmoney;

public class PostgresPlugin
extends JdbiPlugin.Singleton {
    public void customizeJdbi(Jdbi jdbi) {
        jdbi.registerArgument((ArgumentFactory)new TypedEnumArgumentFactory());
        jdbi.registerArgument((ArgumentFactory)new JavaTimeArgumentFactory());
        jdbi.registerArgument((ArgumentFactory)new DurationArgumentFactory());
        jdbi.registerArgument((ArgumentFactory)new PeriodArgumentFactory());
        jdbi.registerArgument((ArgumentFactory)new InetArgumentFactory());
        jdbi.registerArgument((ArgumentFactory)new HStoreArgumentFactory());
        jdbi.registerArgument((ArgumentFactory)new MacAddrArgumentFactory());
        jdbi.registerArgument((ArgumentFactory)new UUIDArgumentFactory());
        jdbi.registerArgument((ArgumentFactory)new PGobjectArgumentFactory());
        jdbi.registerArrayType(Integer.TYPE, "integer");
        jdbi.registerArrayType(Integer.class, "integer");
        jdbi.registerArrayType(Long.TYPE, "bigint");
        jdbi.registerArrayType(Long.class, "bigint");
        jdbi.registerArrayType(String.class, "varchar");
        jdbi.registerArrayType(UUID.class, "uuid");
        jdbi.registerArrayType(Float.TYPE, "real");
        jdbi.registerArrayType(Float.class, "real");
        jdbi.registerArrayType(Double.TYPE, "double precision");
        jdbi.registerArrayType(Double.class, "double precision");
        jdbi.registerArrayType(PGbox.class, "box");
        jdbi.registerArrayType(PGcircle.class, "circle");
        jdbi.registerArrayType(PGInterval.class, "interval");
        jdbi.registerArrayType(PGline.class, "line");
        jdbi.registerArrayType(PGlseg.class, "lseg");
        jdbi.registerArrayType(PGmoney.class, "money");
        jdbi.registerArrayType(PGpath.class, "path");
        jdbi.registerArrayType(PGpoint.class, "point");
        jdbi.registerArrayType(PGpolygon.class, "polygon");
        jdbi.registerColumnMapper((ColumnMapperFactory)new JavaTimeMapperFactory());
        jdbi.registerColumnMapper((ColumnMapper)new HStoreColumnMapper());
        jdbi.registerColumnMapper((ColumnMapper)new MacAddrColumnMapper());
        jdbi.registerColumnMapper((ColumnMapperFactory)new DurationColumnMapperFactory());
        jdbi.registerColumnMapper((ColumnMapperFactory)new PeriodColumnMapperFactory());
        jdbi.registerColumnMapper((ColumnMapperFactory)new PGobjectColumnMapperFactory());
        jdbi.registerArgument((arg_0, arg_1, arg_2) -> ((HStoreArgumentFactory)new HStoreArgumentFactory()).build(arg_0, arg_1, arg_2));
        jdbi.registerColumnMapper((GenericType)new GenericType<Map<String, String>>(){}, (ColumnMapper)new HStoreColumnMapper());
        if (JdbiClassUtils.isPresent((String)"org.jdbi.v3.json.JsonConfig")) {
            jdbi.registerArgument((ArgumentFactory)new JsonArgumentFactory());
        }
    }

    public Handle customizeHandle(Handle handle) {
        PGConnection pgConnection = (PGConnection)Unchecked.supplier(() -> handle.getConnection().unwrap(PGConnection.class)).get();
        return (Handle)handle.configure(PostgresTypes.class, pt -> pt.addTypesToConnection(pgConnection));
    }
}

