/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.pg;

import java.lang.reflect.Array;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import org.jdbi.v3.StatementContext;
import org.jdbi.v3.argument.Argument;
import org.jdbi.v3.argument.ArgumentFactory;
import org.jdbi.v3.pg.ArrayArgument;
import org.jdbi.v3.util.GenericTypes;

public class SqlArrayArgumentFactory
implements ArgumentFactory {
    private static final Map<Class<?>, String> BEST_GUESS;

    public Optional<Argument> build(Type type, Object value, StatementContext ctx) {
        return GenericTypes.getErasedType((Type)type).isArray() ? Optional.of(ArrayArgument.fromAnyArray(SqlArrayArgumentFactory.guessSqlType(value), value)) : Optional.empty();
    }

    static final String guessSqlType(Object array) {
        Class<?> klass = array.getClass();
        if (!klass.isArray()) {
            throw new IllegalArgumentException("not an array: " + klass);
        }
        String guess = BEST_GUESS.get(klass.getComponentType());
        if (Array.getLength(array) == 0 || guess == null) {
            return "varchar";
        }
        return guess;
    }

    static {
        IdentityHashMap<Class<Double>, String> map = new IdentityHashMap<Class<Double>, String>();
        map.put(Integer.TYPE, "integer");
        map.put(Integer.class, "integer");
        map.put(Long.TYPE, "bigint");
        map.put(Long.class, "bigint");
        map.put(String.class, "varchar");
        map.put(UUID.class, "uuid");
        map.put(Float.TYPE, "real");
        map.put(Float.class, "real");
        map.put(Double.TYPE, "double precision");
        map.put(Double.class, "double precision");
        BEST_GUESS = Collections.unmodifiableMap(map);
    }
}

