/*
 * Decompiled with CFR 0.152.
 */
package org.jdbcdslog;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jdbcdslog.ConfigurationParameters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LogUtils {
    static Logger logger = LoggerFactory.getLogger(LogUtils.class);
    private static final String NAMED_PARAMETERS_PREFIX = ":";

    public static void handleException(Throwable e, Logger l, StringBuilder msg) throws Throwable {
        if (e instanceof InvocationTargetException) {
            e = ((InvocationTargetException)e).getTargetException();
        }
        l.error(msg.toString(), e);
        throw e;
    }

    public static StringBuilder appendElapsedTime(StringBuilder sb, long elapsedTimeInNano) {
        if (ConfigurationParameters.showTime.booleanValue()) {
            sb.append("\nElapsed Time: ").append(String.format("%.9f", (double)elapsedTimeInNano / 1.0E9)).append(" s.");
        }
        return sb;
    }

    public static String appendStackTrace(String message) {
        if (ConfigurationParameters.printStackTrace) {
            return LogUtils.appendStackTrace(new StringBuilder(message)).toString();
        }
        return message;
    }

    public static StringBuilder appendStackTrace(StringBuilder sb) {
        block6: {
            if (!ConfigurationParameters.printStackTrace) break block6;
            StackTraceElement[] stackTraces = new Throwable().getStackTrace();
            int firstNonJdbcDsLogStackIndex = LogUtils.firstNonJdbcDsLogStackIndex(stackTraces);
            if (ConfigurationParameters.printFullStackTrace) {
                for (int i = firstNonJdbcDsLogStackIndex; i < stackTraces.length; ++i) {
                    sb.append("\nat ").append(stackTraces[i]);
                }
            } else if (ConfigurationParameters.printStackTracePattern.length() == 0) {
                sb.append("\nat ").append(stackTraces[firstNonJdbcDsLogStackIndex]);
            } else {
                String matchPattern = ConfigurationParameters.printStackTracePattern;
                for (StackTraceElement stackTraceElement : stackTraces) {
                    if (!stackTraceElement.getClassName().matches(matchPattern)) continue;
                    sb.append("\nat ").append(stackTraceElement);
                    break;
                }
            }
        }
        return sb;
    }

    public static int firstNonJdbcDsLogStackIndex(StackTraceElement[] stackTraces) {
        int i = 0;
        for (i = 0; i < stackTraces.length && stackTraces[i].getClassName().startsWith("org.jdbcdslog"); ++i) {
        }
        if (i > 0) {
            ++i;
        }
        return i;
    }

    public static StringBuilder createLogEntry(Method method, String sql, Map<Integer, Object> parameters, Map<String, Object> namedParameters) {
        StringBuilder s = new StringBuilder();
        if (method != null) {
            s.append(method.getDeclaringClass().getName()).append(".").append(method.getName()).append(": ");
        }
        LogUtils.appendSql(s, sql, parameters, namedParameters);
        return s;
    }

    public static void appendSql(StringBuilder s, String sql, Map<Integer, Object> parameters, Map<String, Object> namedParameters) {
        if (ConfigurationParameters.inlineQueryParams) {
            if (parameters != null && !parameters.isEmpty()) {
                LogUtils.appendSqlWithInlineIndexedParams(s, sql, parameters);
            } else {
                LogUtils.appendSqlWithInlineNamedParams(s, sql, namedParameters);
            }
        } else {
            LogUtils.appendSqlWithSeparateParams(s, sql, parameters, namedParameters);
        }
    }

    protected static void appendSqlWithSeparateParams(StringBuilder s, String sql, Map<Integer, Object> parameters, Map<String, Object> namedParameters) {
        if (sql != null) {
            s.append(sql);
        }
        if (parameters != null && !parameters.isEmpty()) {
            s.append(" parameters: ").append(parameters);
        } else if (namedParameters != null && !namedParameters.isEmpty()) {
            s.append(" named parameters: ").append(namedParameters);
        }
    }

    public static void appendBatchSqls(StringBuilder s, String sql, List<Map<Integer, Object>> parameters, List<Map<String, Object>> namedParameters) {
        if (ConfigurationParameters.inlineQueryParams) {
            if (parameters != null) {
                for (Map<Object, Object> map : parameters) {
                    s.append("\n");
                    LogUtils.appendSqlWithInlineIndexedParams(s, sql, map);
                }
            }
            if (namedParameters != null) {
                for (Map<Object, Object> map : namedParameters) {
                    s.append("\n");
                    LogUtils.appendSqlWithInlineNamedParams(s, sql, map);
                }
            }
        } else {
            LogUtils.appendBatchSqlsWithSeparateParams(s, sql, parameters, namedParameters);
        }
    }

    protected static void appendBatchSqlsWithSeparateParams(StringBuilder s, String sql, List<Map<Integer, Object>> parameters, List<Map<String, Object>> namedParameters) {
        if (sql != null) {
            s.append(sql);
        }
        if (parameters != null && !parameters.isEmpty()) {
            s.append(" parameters: ").append(parameters);
        } else if (namedParameters != null && !namedParameters.isEmpty()) {
            s.append(" named parameters: ").append(namedParameters);
        }
    }

    protected static void appendSqlWithInlineIndexedParams(StringBuilder sb, String sql, Map<Integer, Object> parameters) {
        if (sql != null) {
            int questionMarkCount = 1;
            Pattern p = Pattern.compile("\\?");
            Matcher m = p.matcher(sql);
            StringBuffer sqlStringBuffer = new StringBuffer();
            while (m.find()) {
                m.appendReplacement(sqlStringBuffer, ConfigurationParameters.rdbmsSpecifics.formatParameter(parameters.get(questionMarkCount)));
                ++questionMarkCount;
            }
            m.appendTail(sqlStringBuffer);
            sb.append(sqlStringBuffer).append(";");
        }
    }

    protected static void appendSqlWithInlineNamedParams(StringBuilder sb, String sql, Map<String, Object> namedParameters) {
        if (sql != null) {
            if (namedParameters != null && !namedParameters.isEmpty()) {
                for (Map.Entry<String, Object> entry : namedParameters.entrySet()) {
                    sql = sql.replaceAll(NAMED_PARAMETERS_PREFIX + entry.getKey(), ConfigurationParameters.rdbmsSpecifics.formatParameter(entry.getValue()));
                }
            }
            sb.append(sql).append(";");
        }
    }

    protected static String replaceEach(String text, String[] searchList, String[] replacementList) {
        if (text == null || text.length() == 0 || searchList == null || searchList.length == 0 || replacementList == null || replacementList.length == 0) {
            return text;
        }
        int searchLength = searchList.length;
        int replacementLength = replacementList.length;
        if (searchLength != replacementLength) {
            throw new IllegalArgumentException("Search and Replace array lengths don't match: " + searchLength + " vs " + replacementLength);
        }
        boolean[] noMoreMatchesForReplIndex = new boolean[searchLength];
        int textIndex = -1;
        int replaceIndex = -1;
        int tempIndex = -1;
        for (int i = 0; i < searchLength; ++i) {
            if (noMoreMatchesForReplIndex[i] || searchList[i] == null || searchList[i].length() == 0 || replacementList[i] == null) continue;
            tempIndex = text.indexOf(searchList[i]);
            if (tempIndex == -1) {
                noMoreMatchesForReplIndex[i] = true;
                continue;
            }
            if (textIndex != -1 && tempIndex >= textIndex) continue;
            textIndex = tempIndex;
            replaceIndex = i;
        }
        if (textIndex == -1) {
            return text;
        }
        int start = 0;
        int increase = 0;
        for (int i = 0; i < searchList.length; ++i) {
            int greater;
            if (searchList[i] == null || replacementList[i] == null || (greater = replacementList[i].length() - searchList[i].length()) <= 0) continue;
            increase += 3 * greater;
        }
        increase = Math.min(increase, text.length() / 5);
        StringBuilder buf = new StringBuilder(text.length() + increase);
        while (textIndex != -1) {
            int i;
            for (i = start; i < textIndex; ++i) {
                buf.append(text.charAt(i));
            }
            buf.append(replacementList[replaceIndex]);
            start = textIndex + searchList[replaceIndex].length();
            textIndex = -1;
            replaceIndex = -1;
            tempIndex = -1;
            for (i = 0; i < searchLength; ++i) {
                if (noMoreMatchesForReplIndex[i] || searchList[i] == null || searchList[i].length() == 0 || replacementList[i] == null) continue;
                tempIndex = text.indexOf(searchList[i], start);
                if (tempIndex == -1) {
                    noMoreMatchesForReplIndex[i] = true;
                    continue;
                }
                if (textIndex != -1 && tempIndex >= textIndex) continue;
                textIndex = tempIndex;
                replaceIndex = i;
            }
        }
        int textLength = text.length();
        for (int i = start; i < textLength; ++i) {
            buf.append(text.charAt(i));
        }
        String result = buf.toString();
        return result;
    }
}

