/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.compute.options;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.primitives.Ints;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.jclouds.compute.options.RunScriptOptions;
import org.jclouds.domain.LoginCredentials;
import org.jclouds.scriptbuilder.domain.Statement;
import org.jclouds.scriptbuilder.domain.Statements;

public class TemplateOptions
extends RunScriptOptions
implements Cloneable {
    private static final Set<Integer> DEFAULT_INBOUND_PORTS = ImmutableSet.of((Object)22);
    public static final TemplateOptions NONE = new ImmutableTemplateOptions(new TemplateOptions());
    protected Set<Integer> inboundPorts = DEFAULT_INBOUND_PORTS;
    protected Statement script;
    protected Set<String> tags = ImmutableSet.of();
    protected String privateKey;
    protected String publicKey;
    protected boolean blockUntilRunning = true;
    protected Map<String, String> userMetadata = Maps.newLinkedHashMap();

    public TemplateOptions clone() {
        TemplateOptions options = new TemplateOptions();
        this.copyTo(options);
        return options;
    }

    public void copyTo(TemplateOptions to) {
        if (!Arrays.equals(to.getInboundPorts(), this.getInboundPorts())) {
            to.inboundPorts(this.getInboundPorts());
        }
        if (this.getRunScript() != null) {
            to.runScript(this.getRunScript());
        }
        if (this.getPrivateKey() != null) {
            to.installPrivateKey(this.getPrivateKey());
        }
        if (this.getPublicKey() != null) {
            to.authorizePublicKey(this.getPublicKey());
        }
        if (this.getPort() != -1) {
            to.blockOnPort(this.getPort(), this.getSeconds());
        }
        if (this.getUserMetadata().size() > 0) {
            to.userMetadata(this.getUserMetadata());
        }
        if (this.getTags().size() > 0) {
            to.tags(this.getTags());
        }
        if (!this.shouldBlockUntilRunning()) {
            to.blockUntilRunning(false);
        }
        if (!this.shouldBlockOnComplete()) {
            to.blockOnComplete(false);
        }
        if (this.getLoginUser() != null) {
            to.overrideLoginUser(this.getLoginUser());
        }
        if (this.getLoginPassword() != null) {
            to.overrideLoginPassword(this.getLoginPassword());
        }
        if (this.getLoginPrivateKey() != null) {
            to.overrideLoginPrivateKey(this.getLoginPrivateKey());
        }
        if (this.shouldAuthenticateSudo() != null) {
            to.overrideAuthenticateSudo(this.shouldAuthenticateSudo());
        }
        if (this.getTaskName() != null) {
            to.nameTask(this.getTaskName());
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TemplateOptions that = (TemplateOptions)TemplateOptions.class.cast(o);
        return super.equals(that) && Objects.equal(this.inboundPorts, that.inboundPorts) && Objects.equal((Object)this.script, (Object)that.script) && Objects.equal((Object)this.publicKey, (Object)that.publicKey) && Objects.equal((Object)this.privateKey, (Object)that.privateKey) && Objects.equal((Object)this.blockUntilRunning, (Object)that.blockUntilRunning) && Objects.equal(this.tags, that.tags) && Objects.equal(this.userMetadata, that.userMetadata);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{super.hashCode(), this.inboundPorts, this.script, this.publicKey, this.privateKey, this.blockUntilRunning, this.tags, this.userMetadata});
    }

    @Override
    public Objects.ToStringHelper string() {
        Objects.ToStringHelper toString = super.string();
        if (!((Object)DEFAULT_INBOUND_PORTS).equals(this.inboundPorts)) {
            toString.add("inboundPorts", this.inboundPorts);
        }
        if (this.script != null) {
            toString.add("scriptPresent", true);
        }
        if (this.publicKey != null) {
            toString.add("publicKeyPresent", true);
        }
        if (this.privateKey != null) {
            toString.add("privateKeyPresent", true);
        }
        if (!this.blockUntilRunning) {
            toString.add("blockUntilRunning", this.blockUntilRunning);
        }
        if (this.tags.size() != 0) {
            toString.add("tags", this.tags);
        }
        if (this.userMetadata.size() != 0) {
            toString.add("userMetadata", this.userMetadata);
        }
        return toString;
    }

    public int[] getInboundPorts() {
        return Ints.toArray(this.inboundPorts);
    }

    public Statement getRunScript() {
        return this.script;
    }

    public Set<String> getTags() {
        return this.tags;
    }

    public String getPrivateKey() {
        return this.privateKey;
    }

    public String getPublicKey() {
        return this.publicKey;
    }

    public boolean shouldBlockUntilRunning() {
        return this.blockUntilRunning;
    }

    public <T extends TemplateOptions> T as(Class<T> clazz) {
        return (T)((TemplateOptions)clazz.cast(this));
    }

    public TemplateOptions runScript(String script) {
        return this.runScript(Statements.exec((String)script));
    }

    public TemplateOptions runScript(Statement script) {
        this.script = (Statement)Preconditions.checkNotNull((Object)script, (Object)"script");
        return this;
    }

    public TemplateOptions installPrivateKey(String privateKey) {
        Preconditions.checkArgument((boolean)((String)Preconditions.checkNotNull((Object)privateKey, (Object)"privateKey")).startsWith("-----BEGIN RSA PRIVATE KEY-----"), (Object)"key should start with -----BEGIN RSA PRIVATE KEY-----");
        this.privateKey = privateKey;
        return this;
    }

    public TemplateOptions dontAuthorizePublicKey() {
        this.publicKey = null;
        return this;
    }

    public TemplateOptions authorizePublicKey(String publicKey) {
        Preconditions.checkArgument((boolean)((String)Preconditions.checkNotNull((Object)publicKey, (Object)"publicKey")).startsWith("ssh-rsa"), (Object)"key should start with ssh-rsa");
        this.publicKey = publicKey;
        return this;
    }

    public TemplateOptions tags(Iterable<String> tags) {
        this.tags = ImmutableSet.copyOf((Iterable)((Iterable)Preconditions.checkNotNull(tags, (Object)"tags")));
        return this;
    }

    public TemplateOptions inboundPorts(int ... ports) {
        for (int port : ports) {
            Preconditions.checkArgument((port > 0 && port < 65536 ? 1 : 0) != 0, (Object)"port must be a positive integer < 65535");
        }
        this.inboundPorts = ImmutableSet.copyOf((Collection)Ints.asList((int[])ports));
        return this;
    }

    public TemplateOptions blockUntilRunning(boolean blockUntilRunning) {
        this.blockUntilRunning = blockUntilRunning;
        if (!blockUntilRunning) {
            this.seconds = -1;
            this.port = -1;
        }
        return this;
    }

    public TemplateOptions userMetadata(Map<String, String> userMetadata) {
        this.userMetadata.putAll((Map)Preconditions.checkNotNull(userMetadata, (Object)"userMetadata"));
        return this;
    }

    public TemplateOptions userMetadata(String key, String value) {
        this.userMetadata.put((String)Preconditions.checkNotNull((Object)key, (Object)"key"), (String)Preconditions.checkNotNull((Object)value, (Object)"value"));
        return this;
    }

    public Map<String, String> getUserMetadata() {
        return this.userMetadata;
    }

    @Override
    public TemplateOptions blockOnPort(int port, int seconds) {
        return (TemplateOptions)TemplateOptions.class.cast(super.blockOnPort(port, seconds));
    }

    @Override
    public TemplateOptions nameTask(String name) {
        return (TemplateOptions)TemplateOptions.class.cast(super.nameTask(name));
    }

    @Override
    public TemplateOptions runAsRoot(boolean runAsRoot) {
        return (TemplateOptions)TemplateOptions.class.cast(super.runAsRoot(runAsRoot));
    }

    @Override
    public TemplateOptions wrapInInitScript(boolean wrapInInitScript) {
        return (TemplateOptions)TemplateOptions.class.cast(super.wrapInInitScript(wrapInInitScript));
    }

    @Override
    public TemplateOptions blockOnComplete(boolean blockOnComplete) {
        return (TemplateOptions)TemplateOptions.class.cast(super.blockOnComplete(blockOnComplete));
    }

    @Override
    public TemplateOptions overrideLoginCredentials(LoginCredentials overridingCredentials) {
        return (TemplateOptions)TemplateOptions.class.cast(super.overrideLoginCredentials(overridingCredentials));
    }

    @Override
    public TemplateOptions overrideLoginPassword(String password) {
        return (TemplateOptions)TemplateOptions.class.cast(super.overrideLoginPassword(password));
    }

    @Override
    public TemplateOptions overrideLoginPrivateKey(String privateKey) {
        return (TemplateOptions)TemplateOptions.class.cast(super.overrideLoginPrivateKey(privateKey));
    }

    @Override
    public TemplateOptions overrideLoginUser(String loginUser) {
        return (TemplateOptions)TemplateOptions.class.cast(super.overrideLoginUser(loginUser));
    }

    @Override
    public TemplateOptions overrideAuthenticateSudo(boolean authenticateSudo) {
        return (TemplateOptions)TemplateOptions.class.cast(super.overrideAuthenticateSudo(authenticateSudo));
    }

    public static class Builder
    extends RunScriptOptions.Builder {
        public static TemplateOptions nameTask(String name) {
            TemplateOptions options = new TemplateOptions();
            return options.nameTask(name);
        }

        public static TemplateOptions overrideLoginUser(String user) {
            TemplateOptions options = new TemplateOptions();
            return options.overrideLoginUser(user);
        }

        public static TemplateOptions overrideLoginPassword(String password) {
            TemplateOptions options = new TemplateOptions();
            return options.overrideLoginPassword(password);
        }

        public static TemplateOptions overrideLoginPrivateKey(String privateKey) {
            TemplateOptions options = new TemplateOptions();
            return options.overrideLoginPrivateKey(privateKey);
        }

        public static TemplateOptions overrideAuthenticateSudo(boolean authenticateSudo) {
            TemplateOptions options = new TemplateOptions();
            return options.overrideAuthenticateSudo(authenticateSudo);
        }

        public static TemplateOptions overrideLoginCredentials(LoginCredentials credentials) {
            TemplateOptions options = new TemplateOptions();
            return options.overrideLoginCredentials(credentials);
        }

        public static TemplateOptions runAsRoot(boolean value) {
            TemplateOptions options = new TemplateOptions();
            return options.runAsRoot(value);
        }

        public static TemplateOptions blockOnPort(int port, int seconds) {
            TemplateOptions options = new TemplateOptions();
            return options.blockOnPort(port, seconds);
        }

        public static TemplateOptions inboundPorts(int ... ports) {
            TemplateOptions options = new TemplateOptions();
            return options.inboundPorts(ports);
        }

        public static TemplateOptions tags(Iterable<String> tags) {
            TemplateOptions options = new TemplateOptions();
            return options.tags(tags);
        }

        public static TemplateOptions blockUntilRunning(boolean blockUntilRunning) {
            TemplateOptions options = new TemplateOptions();
            return options.blockUntilRunning(blockUntilRunning);
        }

        public static TemplateOptions runScript(Statement script) {
            TemplateOptions options = new TemplateOptions();
            return options.runScript(script);
        }

        public static TemplateOptions runScript(String script) {
            TemplateOptions options = new TemplateOptions();
            return options.runScript(script);
        }

        public static TemplateOptions installPrivateKey(String rsaKey) {
            TemplateOptions options = new TemplateOptions();
            return options.installPrivateKey(rsaKey);
        }

        public static TemplateOptions authorizePublicKey(String rsaKey) {
            TemplateOptions options = new TemplateOptions();
            return options.authorizePublicKey(rsaKey);
        }

        public static TemplateOptions userMetadata(Map<String, String> userMetadata) {
            TemplateOptions options = new TemplateOptions();
            return options.userMetadata(userMetadata);
        }

        public static TemplateOptions userMetadata(String key, String value) {
            TemplateOptions options = new TemplateOptions();
            return options.userMetadata(key, value);
        }

        public static TemplateOptions blockOnComplete(boolean value) {
            TemplateOptions options = new TemplateOptions();
            return options.blockOnComplete(value);
        }
    }

    public static class ImmutableTemplateOptions
    extends TemplateOptions {
        private final TemplateOptions delegate;

        @Override
        public TemplateOptions clone() {
            return this.delegate.clone();
        }

        @Override
        public String getTaskName() {
            return this.delegate.getTaskName();
        }

        @Override
        public int getPort() {
            return this.delegate.getPort();
        }

        @Override
        public int getSeconds() {
            return this.delegate.getSeconds();
        }

        @Override
        public boolean shouldRunAsRoot() {
            return this.delegate.shouldRunAsRoot();
        }

        @Override
        public boolean shouldBlockOnComplete() {
            return this.delegate.shouldBlockOnComplete();
        }

        @Override
        public boolean shouldWrapInInitScript() {
            return this.delegate.shouldWrapInInitScript();
        }

        @Override
        public void copyTo(TemplateOptions to) {
            this.delegate.copyTo(to);
        }

        public ImmutableTemplateOptions(TemplateOptions delegate) {
            this.delegate = delegate;
        }

        @Override
        public String toString() {
            return this.delegate.toString();
        }

        @Override
        public TemplateOptions runScript(Statement script) {
            throw new IllegalArgumentException("script is immutable");
        }

        @Override
        public TemplateOptions dontAuthorizePublicKey() {
            throw new IllegalArgumentException("public key is immutable");
        }

        @Override
        public TemplateOptions blockOnPort(int port, int seconds) {
            throw new IllegalArgumentException("ports are immutable");
        }

        @Override
        public TemplateOptions nameTask(String name) {
            throw new IllegalArgumentException("task name is immutable");
        }

        @Override
        public TemplateOptions runAsRoot(boolean runAsRoot) {
            throw new IllegalArgumentException("runAsRoot is immutable");
        }

        @Override
        public TemplateOptions wrapInInitScript(boolean wrapInInitScript) {
            throw new IllegalArgumentException("wrapInInitScript is immutable");
        }

        @Override
        public TemplateOptions blockOnComplete(boolean blockOnComplete) {
            throw new IllegalArgumentException("blockOnComplete is immutable");
        }

        @Override
        public TemplateOptions overrideLoginCredentials(LoginCredentials overridingCredentials) {
            throw new IllegalArgumentException("overridingCredentials is immutable");
        }

        @Override
        public TemplateOptions overrideLoginPassword(String password) {
            throw new IllegalArgumentException("password is immutable");
        }

        @Override
        public TemplateOptions overrideLoginPrivateKey(String privateKey) {
            throw new IllegalArgumentException("privateKey is immutable");
        }

        @Override
        public TemplateOptions overrideAuthenticateSudo(boolean authenticateSudo) {
            throw new IllegalArgumentException("authenticateSudo is immutable");
        }

        @Override
        public String getLoginUser() {
            return this.delegate.getLoginUser();
        }

        @Override
        public Boolean shouldAuthenticateSudo() {
            return this.delegate.shouldAuthenticateSudo();
        }

        @Override
        public String getLoginPassword() {
            return this.delegate.getLoginPassword();
        }

        @Override
        public String getLoginPrivateKey() {
            return this.delegate.getLoginPrivateKey();
        }

        @Override
        public TemplateOptions overrideLoginUser(String loginUser) {
            throw new IllegalArgumentException("loginUser is immutable");
        }

        @Override
        public <T extends TemplateOptions> T as(Class<T> clazz) {
            return this.delegate.as(clazz);
        }

        @Override
        public TemplateOptions authorizePublicKey(String publicKey) {
            throw new IllegalArgumentException("publicKey is immutable");
        }

        @Override
        public TemplateOptions blockUntilRunning(boolean blockUntilRunning) {
            throw new IllegalArgumentException("blockUntilRunning is immutable");
        }

        @Override
        public int[] getInboundPorts() {
            return this.delegate.getInboundPorts();
        }

        @Override
        public String getPrivateKey() {
            return this.delegate.getPrivateKey();
        }

        @Override
        public String getPublicKey() {
            return this.delegate.getPublicKey();
        }

        @Override
        public Statement getRunScript() {
            return this.delegate.getRunScript();
        }

        @Override
        public boolean shouldBlockUntilRunning() {
            return this.delegate.shouldBlockUntilRunning();
        }

        @Override
        public TemplateOptions inboundPorts(int ... ports) {
            throw new IllegalArgumentException("ports are immutable");
        }

        @Override
        public TemplateOptions installPrivateKey(String privateKey) {
            throw new IllegalArgumentException("privateKey is immutable");
        }

        @Override
        public Set<String> getTags() {
            return this.delegate.getTags();
        }

        @Override
        public TemplateOptions tags(Iterable<String> tags) {
            throw new IllegalArgumentException("tags are immutable");
        }

        @Override
        public TemplateOptions userMetadata(Map<String, String> userMetadata) {
            throw new IllegalArgumentException("userMetadata is immutable");
        }

        @Override
        public TemplateOptions userMetadata(String key, String value) {
            throw new IllegalArgumentException("userMetadata is immutable");
        }

        @Override
        public Map<String, String> getUserMetadata() {
            return this.delegate.getUserMetadata();
        }
    }
}

