/**
 * Copyright 2010 Red Hat, Inc. and/or its affiliates.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.jbpm.process.workitem.email;

import java.lang.reflect.Field;

public class Connection {

    public Connection() { }
    
    public Connection(String host, String port, String userName, String password) { 
       this.host = host; 
       this.port = port; 
       this.userName = userName; 
       this.password =  password; 
    }
    
    public Connection(String host, String port) { 
       this.host = host; 
       this.port = port; 
    }
    
    private String host;
    private String port;
    private String userName;
    private String password;
    private Boolean startTls;

    public int hashCode() {
        final int prime = 31;
        int result = 1;
        result = prime * result + ((host == null) ? 0 : host.hashCode());
        result = prime * result + ((password == null) ? 0 : password.hashCode());
        result = prime * result + ((port == null) ? 0 : port.hashCode());
        result = prime * result + ((userName == null) ? 0 : userName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if ( this == obj ) return true;
        if ( obj == null ) return false;
        if ( getClass() != obj.getClass() ) return false;

        Field [] fields = Connection.class.getDeclaredFields();
        for( int i = 0; i < fields.length; ++i ) { 
            try {
                Object thisVal = fields[i].get(this);
                Object thatVal = fields[i].get(obj);
                if( thisVal != null && thatVal != null ) {
                    if( ! thisVal.equals(thatVal) ) { 
                        return false;
                    }
                }
                else if( thisVal != thatVal ) { 
                    return false; 
                }
            } catch (Exception e) {
                return false;
            }
        }

        return true;
    }

    public String getHost() {
        return host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getPort() {
        return port;
    }

    public void setPort(String port) {
        this.port = port;
    }

    public String getUserName() {
        return userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getPassword() {
        return password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public Boolean getStartTls() {
        return startTls;
    }

    public void setStartTls(boolean startTls) {
        this.startTls = startTls;
    }

}
