/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.runtime.manager.impl.deploy;

import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;
import javax.persistence.EntityManagerFactory;
import org.kie.api.KieServices;
import org.kie.api.executor.ExecutorService;
import org.kie.api.runtime.manager.RuntimeManager;
import org.kie.api.task.TaskService;
import org.kie.internal.identity.IdentityProvider;
import org.kie.internal.runtime.Cacheable;
import org.kie.internal.runtime.conf.ObjectModel;
import org.kie.internal.runtime.conf.ObjectModelResolver;
import org.kie.internal.runtime.manager.InternalRuntimeManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReflectionObjectModelResolver
implements ObjectModelResolver {
    private static final Logger logger = LoggerFactory.getLogger(ReflectionObjectModelResolver.class);
    public static final String ID = "reflection";
    private Map<String, Class<?>> knownContextParamMapping = new HashMap();

    public ReflectionObjectModelResolver() {
        this.knownContextParamMapping.put("entityManagerFactory", EntityManagerFactory.class);
        this.knownContextParamMapping.put("runtimeManager", RuntimeManager.class);
        this.knownContextParamMapping.put("kieSession", KieServices.class);
        this.knownContextParamMapping.put("taskService", TaskService.class);
        this.knownContextParamMapping.put("executorService", ExecutorService.class);
        this.knownContextParamMapping.put("classLoader", ClassLoader.class);
        this.knownContextParamMapping.put("identityProvider", IdentityProvider.class);
    }

    public Object getInstance(ObjectModel model, ClassLoader cl, Map<String, Object> contextParams) {
        Class<?> clazz = this.getClassObject(model.getIdentifier(), cl);
        Object instance = null;
        InternalRuntimeManager manager = null;
        if (contextParams.containsKey("runtimeManager") && (instance = (manager = (InternalRuntimeManager)contextParams.get("runtimeManager")).getCacheManager().get(clazz.getName())) != null) {
            return instance;
        }
        if (model.getParameters() == null || model.getParameters().isEmpty()) {
            logger.debug("About to create instance of {} with no arg constructor", (Object)model.getIdentifier());
            try {
                instance = clazz.newInstance();
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Unable to create instance (no arg constructor) of type " + model.getIdentifier() + " due to " + e.getMessage(), e);
            }
        }
        logger.debug("About to create instance of {} with {} parameters", (Object)model.getIdentifier(), (Object)model.getParameters().size());
        Class[] parameterTypes = new Class[model.getParameters().size()];
        Object[] paramInstances = new Object[model.getParameters().size()];
        int index = 0;
        for (Object param : model.getParameters()) {
            if (param instanceof ObjectModel) {
                Class<?> paramclazz;
                logger.debug("Parameter is of type ObjectModel (id: {}), trying to create instance based on that model", (Object)((ObjectModel)param).getIdentifier());
                parameterTypes[index] = paramclazz = this.getClassObject(((ObjectModel)param).getIdentifier(), cl);
                paramInstances[index] = this.getInstance((ObjectModel)param, cl, contextParams);
            } else if (contextParams.containsKey(param)) {
                logger.debug("Parametr references context parametr with name {}", param);
                Object contextValue = contextParams.get(param);
                Class<?> paramClass = contextValue.getClass();
                if (this.knownContextParamMapping.containsKey(param)) {
                    paramClass = this.knownContextParamMapping.get(param);
                }
                parameterTypes[index] = paramClass;
                paramInstances[index] = contextValue;
            } else {
                logger.debug("Parameter is simple type (string) - {}", param);
                parameterTypes[index] = param.getClass();
                paramInstances[index] = param;
            }
            ++index;
        }
        try {
            logger.debug("Creating instance of class {} with parameter types {} and parameter instances {}", new Object[]{clazz, parameterTypes, paramInstances});
            Constructor<?> constructor = clazz.getConstructor(parameterTypes);
            instance = constructor.newInstance(paramInstances);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Unable to create instance (" + parameterTypes + " constructor) of type " + model.getIdentifier() + " due to " + e.getMessage(), e);
        }
        logger.debug("Created instance : {}", instance);
        if (manager != null && instance instanceof Cacheable) {
            manager.getCacheManager().add(instance.getClass().getName(), instance);
        }
        return instance;
    }

    public boolean accept(String resolverId) {
        if (ID.equals(resolverId)) {
            return true;
        }
        logger.debug("Resolver id {} is not accepted by {}", (Object)resolverId, this.getClass());
        return false;
    }

    protected Class<?> getClassObject(String classname, ClassLoader cl) {
        try {
            Class<?> clazz = Class.forName(classname, true, cl);
            return clazz;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Unable to create class of type " + classname + " due to " + e.getMessage(), e);
        }
    }
}

