/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.runtime.manager.impl.jpa;

import java.io.Serializable;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.Lob;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;

@Entity
@Table(name="TimerMappingInfo", indexes={@Index(name="IDX_TMI_KSessionUUID", unique=true, columnList="kieSessionId,uuid")})
@SequenceGenerator(name="timerMappingInfoIdSeq", sequenceName="TIMER_MAPPING_INFO_ID_SEQ")
public class TimerMappingInfo
implements Serializable {
    private static final long serialVersionUID = 533985957655465840L;
    @Id
    @GeneratedValue(strategy=GenerationType.AUTO, generator="timerMappingInfoIdSeq")
    private Long id;
    private long timerId;
    private String externalTimerId;
    private long kieSessionId;
    @Column(nullable=false)
    private String uuid;
    @Lob
    @Column(length=0x7FFFFFFF)
    private byte[] info;

    public TimerMappingInfo() {
    }

    public TimerMappingInfo(long timerId, String externalTimerId, long kieSessionId, String uuid) {
        this.timerId = timerId;
        this.externalTimerId = externalTimerId;
        this.kieSessionId = kieSessionId;
        this.uuid = uuid;
    }

    public String getUuid() {
        return this.uuid;
    }

    public void setUuid(String uuid) {
        this.uuid = uuid;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getExternalTimerId() {
        return this.externalTimerId;
    }

    public void setExternalTimerId(String externalTimerId) {
        this.externalTimerId = externalTimerId;
    }

    public long getKieSessionId() {
        return this.kieSessionId;
    }

    public void setKieSessionId(long kieSessionId) {
        this.kieSessionId = kieSessionId;
    }

    public long getTimerId() {
        return this.timerId;
    }

    public void setTimerId(long timerId) {
        this.timerId = timerId;
    }

    public byte[] getInfo() {
        return this.info;
    }

    public void setInfo(byte[] info) {
        this.info = info;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.externalTimerId == null ? 0 : this.externalTimerId.hashCode());
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (int)(this.kieSessionId ^ this.kieSessionId >>> 32);
        result = 31 * result + (int)(this.timerId ^ this.timerId >>> 32);
        result = 31 * result + (this.uuid == null ? 0 : this.uuid.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TimerMappingInfo other = (TimerMappingInfo)obj;
        if (this.externalTimerId == null ? other.externalTimerId != null : !this.externalTimerId.equals(other.externalTimerId)) {
            return false;
        }
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        if (this.kieSessionId != other.kieSessionId) {
            return false;
        }
        if (this.timerId != other.timerId) {
            return false;
        }
        return !(this.uuid == null ? other.uuid != null : !this.uuid.equals(other.uuid));
    }

    public String toString() {
        return "TimerMappingInfo [id=" + this.id + ", timerId=" + this.timerId + ", externalTimerId=" + this.externalTimerId + ", kieSessionId=" + this.kieSessionId + ", uuid=" + this.uuid + "]";
    }
}

