/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.runtime.manager.impl.error;

import java.lang.reflect.Constructor;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.function.Function;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import org.drools.persistence.api.TransactionManager;
import org.drools.persistence.api.TransactionManagerFactory;
import org.jbpm.runtime.manager.impl.jpa.ExecutionErrorInfo;
import org.kie.api.runtime.Environment;
import org.kie.internal.runtime.error.ExecutionError;
import org.kie.internal.runtime.error.ExecutionErrorStorage;

public class DefaultExecutionErrorStorage
implements ExecutionErrorStorage {
    private static String SPRING_TM_CLASSNAME = "org.springframework.transaction.support.AbstractPlatformTransactionManager";
    private static String KIE_SPRING_TM_CLASSNAME = "org.kie.spring.persistence.KieSpringTransactionManager";
    private EntityManagerFactory emf;
    private TransactionManager txm;

    public DefaultExecutionErrorStorage(Environment environment) {
        this.emf = (EntityManagerFactory)environment.get("org.kie.api.persistence.jpa.EntityManagerFactory");
        if (this.emf != null) {
            this.txm = this.getTransactionManager(environment);
        }
    }

    public ExecutionError store(ExecutionError error) {
        if (!this.isActive()) {
            return error;
        }
        return this.call(em -> {
            ExecutionErrorInfo errorEntity = new ExecutionErrorInfo(error.getErrorId(), error.getType(), error.getDeploymentId(), error.getProcessInstanceId(), error.getProcessId(), error.getActivityId(), error.getActivityName(), error.getJobId(), error.getErrorMessage(), error.getError(), error.getErrorDate(), error.getInitActivityId());
            em.persist((Object)errorEntity);
            return error;
        });
    }

    public List<ExecutionError> list(Integer page, Integer pageSize) {
        if (!this.isActive()) {
            return Collections.EMPTY_LIST;
        }
        int startPosition = page * pageSize;
        return this.call(em -> em.createQuery("from ExecutionErrorInfo").setFirstResult(startPosition).setMaxResults(pageSize.intValue()).getResultList());
    }

    public ExecutionError get(String errorId) {
        if (!this.isActive()) {
            return null;
        }
        return (ExecutionError)this.call(em -> em.createQuery("from ExecutionErrorInfo where errorId =:errorId").setParameter("errorId", (Object)errorId).getSingleResult());
    }

    public void acknowledge(String user, String ... errorIds) {
        if (!this.isActive()) {
            return;
        }
        this.call(em -> {
            for (String errorId : errorIds) {
                ExecutionError error = (ExecutionError)em.createQuery("from ExecutionErrorInfo where errorId =:errorId").setParameter("errorId", (Object)errorId).getSingleResult();
                error.setAcknowledged(true);
                error.setAcknowledgedBy(user);
                error.setAcknowledgedAt(new Date());
                em.merge((Object)error);
            }
            return null;
        });
    }

    public List<ExecutionError> listByProcessInstance(Long processInstanceId, Integer page, Integer pageSize) {
        if (!this.isActive()) {
            return Collections.EMPTY_LIST;
        }
        int startPosition = page * pageSize;
        return this.call(em -> em.createQuery("from ExecutionErrorInfo where processInstanceId =:processInstanceId").setParameter("processInstanceId", (Object)processInstanceId).setFirstResult(startPosition).setMaxResults(pageSize.intValue()).getResultList());
    }

    public List<ExecutionError> listByActivity(String activityName, Integer page, Integer pageSize) {
        if (!this.isActive()) {
            return Collections.EMPTY_LIST;
        }
        int startPosition = page * pageSize;
        return this.call(em -> em.createQuery("from ExecutionErrorInfo where activityName =:activityName").setParameter("activityName", (Object)activityName).setFirstResult(startPosition).setMaxResults(pageSize.intValue()).getResultList());
    }

    public List<ExecutionError> listByDeployment(String deploymentId, Integer page, Integer pageSize) {
        if (!this.isActive()) {
            return Collections.EMPTY_LIST;
        }
        int startPosition = page * pageSize;
        return this.call(em -> em.createQuery("from ExecutionErrorInfo where deploymentId =:deploymentId").setParameter("deploymentId", (Object)deploymentId).setFirstResult(startPosition).setMaxResults(pageSize.intValue()).getResultList());
    }

    protected <R> R call(Function<EntityManager, R> function) {
        boolean transactionOwner = false;
        try {
            transactionOwner = this.txm.begin();
            EntityManager em = this.emf.createEntityManager();
            R result = function.apply(em);
            this.txm.commit(transactionOwner);
            em.close();
            return result;
        }
        catch (Exception e) {
            this.txm.rollback(transactionOwner);
            throw new RuntimeException("Exception when persisting error information", e);
        }
    }

    protected TransactionManager getTransactionManager(Environment environment) {
        Object tx = environment.get("org.kie.transaction.TransactionManager");
        if (tx != null) {
            if (tx instanceof TransactionManager) {
                return (TransactionManager)tx;
            }
            if (this.isSpringTransactionManager(tx.getClass())) {
                try {
                    Class<?> cls = Class.forName(KIE_SPRING_TM_CLASSNAME);
                    Constructor<?> con = cls.getConstructors()[0];
                    return (TransactionManager)con.newInstance(tx);
                }
                catch (Exception e) {
                    throw new RuntimeException("Not possible to create spring transaction manager", e);
                }
            }
        }
        return TransactionManagerFactory.get().newTransactionManager(environment);
    }

    protected boolean isSpringTransactionManager(Class<?> clazz) {
        if (SPRING_TM_CLASSNAME.equals(clazz.getName())) {
            return true;
        }
        if (clazz.getSuperclass() != null) {
            return this.isSpringTransactionManager(clazz.getSuperclass());
        }
        return false;
    }

    protected boolean isActive() {
        return this.emf != null && this.txm != null;
    }
}

