/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.runtime.manager.impl.mapper;

import java.util.ArrayList;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.NoResultException;
import javax.persistence.NonUniqueResultException;
import javax.persistence.Query;
import org.jbpm.runtime.manager.impl.jpa.ContextMappingInfo;
import org.jbpm.runtime.manager.impl.mapper.EnvironmentAwareProcessInstanceContext;
import org.jbpm.runtime.manager.impl.mapper.InternalMapper;
import org.kie.api.runtime.Environment;
import org.kie.api.runtime.manager.Context;
import org.kie.internal.process.CorrelationKey;
import org.kie.internal.process.CorrelationProperty;
import org.kie.internal.runtime.manager.context.CorrelationKeyContext;
import org.kie.internal.runtime.manager.context.ProcessInstanceIdContext;

public class JPAMapper
extends InternalMapper {
    private EntityManagerFactory emf;

    public JPAMapper(EntityManagerFactory emf) {
        this.emf = emf;
    }

    public void saveMapping(Context context, Long ksessionId, String ownerId) {
        EntityManagerInfo info = this.getEntityManager(context);
        EntityManager em = info.getEntityManager();
        em.persist((Object)new ContextMappingInfo(this.resolveContext(context, em).getContextId().toString(), ksessionId, ownerId));
        if (!info.isShared()) {
            em.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long findMapping(Context context, String ownerId) {
        EntityManagerInfo info = this.getEntityManager(context);
        EntityManager em = info.getEntityManager();
        try {
            ContextMappingInfo contextMapping = this.findContextByContextId(this.resolveContext(context, em), ownerId, em);
            if (contextMapping != null) {
                Long l = contextMapping.getKsessionId();
                return l;
            }
            Long l = null;
            return l;
        }
        finally {
            if (!info.isShared()) {
                em.close();
            }
        }
    }

    public void removeMapping(Context context, String ownerId) {
        EntityManagerInfo info = this.getEntityManager(context);
        EntityManager em = info.getEntityManager();
        ContextMappingInfo contextMapping = this.findContextByContextId(this.resolveContext(context, em), ownerId, em);
        if (contextMapping != null) {
            em.remove((Object)contextMapping);
        }
        if (!info.isShared()) {
            em.close();
        }
    }

    protected Context resolveContext(Context orig, EntityManager em) {
        if (orig instanceof CorrelationKeyContext) {
            return this.getProcessInstanceByCorrelationKey((CorrelationKey)orig.getContextId(), em);
        }
        return orig;
    }

    protected ContextMappingInfo findContextByContextId(Context context, String ownerId, EntityManager em) {
        try {
            Query findQuery = em.createNamedQuery("FindContextMapingByContextId").setParameter("contextId", (Object)context.getContextId().toString()).setParameter("ownerId", (Object)ownerId);
            ContextMappingInfo contextMapping = (ContextMappingInfo)findQuery.getSingleResult();
            return contextMapping;
        }
        catch (NoResultException e) {
            return null;
        }
        catch (NonUniqueResultException e) {
            return null;
        }
    }

    public Context getProcessInstanceByCorrelationKey(CorrelationKey correlationKey, EntityManager em) {
        Query processInstancesForEvent = em.createNamedQuery("GetProcessInstanceIdByCorrelation");
        processInstancesForEvent.setParameter("elem_count", (Object)new Long(correlationKey.getProperties().size()));
        ArrayList<Object> properties = new ArrayList<Object>();
        for (CorrelationProperty property : correlationKey.getProperties()) {
            properties.add(property.getValue());
        }
        processInstancesForEvent.setParameter("properties", properties);
        try {
            return ProcessInstanceIdContext.get((Long)((Long)processInstancesForEvent.getSingleResult()));
        }
        catch (NonUniqueResultException e) {
            return null;
        }
        catch (NoResultException e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object findContextId(Long ksessionId, String ownerId) {
        EntityManagerInfo info = this.getEntityManager(null);
        EntityManager em = info.getEntityManager();
        try {
            Query findQuery = em.createNamedQuery("FindContextMapingByKSessionId").setParameter("ksessionId", (Object)ksessionId).setParameter("ownerId", (Object)ownerId);
            ContextMappingInfo contextMapping = (ContextMappingInfo)findQuery.getSingleResult();
            String string = contextMapping.getContextId();
            return string;
        }
        catch (NoResultException e) {
            Object var6_9 = null;
            return var6_9;
        }
        catch (NonUniqueResultException e) {
            Object var6_10 = null;
            return var6_10;
        }
        finally {
            if (!info.isShared()) {
                em.close();
            }
        }
    }

    private EntityManagerInfo getEntityManager(Context context) {
        Environment env = null;
        if (context instanceof EnvironmentAwareProcessInstanceContext) {
            env = ((EnvironmentAwareProcessInstanceContext)context).getEnvironment();
        }
        if (env != null) {
            EntityManager em = (EntityManager)env.get("org.kie.api.persistence.jpa.CmdScopedEntityManager");
            if (em != null) {
                return new EntityManagerInfo(em, true);
            }
            EntityManagerFactory emf = (EntityManagerFactory)env.get("org.kie.api.persistence.jpa.EntityManagerFactory");
            if (emf != null) {
                return new EntityManagerInfo(emf.createEntityManager(), false);
            }
        } else {
            return new EntityManagerInfo(this.emf.createEntityManager(), false);
        }
        throw new RuntimeException("Could not find EntityManager, both command-scoped EM and EMF in environment are null");
    }

    public List<Long> findKSessionToInit(String ownerId) {
        EntityManager em = this.emf.createEntityManager();
        Query findQuery = em.createNamedQuery("FindKSessionToInit").setParameter("ownerId", (Object)ownerId);
        return findQuery.getResultList();
    }

    @Override
    public List<String> findContextIdForEvent(String eventType, String ownerId) {
        EntityManager em = this.emf.createEntityManager();
        Query findQuery = em.createNamedQuery("FindProcessInstanceWaitingForEvent").setParameter("eventType", (Object)eventType).setParameter("ownerId", (Object)ownerId);
        return findQuery.getResultList();
    }

    private class EntityManagerInfo {
        private EntityManager entityManager;
        private boolean shared;

        public EntityManagerInfo(EntityManager entityManager, boolean shared) {
            this.entityManager = entityManager;
            this.shared = shared;
        }

        public EntityManager getEntityManager() {
            return this.entityManager;
        }

        public boolean isShared() {
            return this.shared;
        }
    }
}

