/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.runtime.manager.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.persistence.EntityManagerFactory;
import org.drools.core.builder.conf.impl.DecisionTableConfigurationImpl;
import org.drools.core.impl.EnvironmentFactory;
import org.jbpm.marshalling.impl.ProcessInstanceResolverStrategy;
import org.jbpm.process.core.timer.GlobalSchedulerService;
import org.jbpm.runtime.manager.api.SchedulerProvider;
import org.jbpm.runtime.manager.impl.SimpleRegisterableItemsFactory;
import org.jbpm.runtime.manager.impl.mapper.InMemoryMapper;
import org.kie.api.KieBase;
import org.kie.api.KieServices;
import org.kie.api.io.Resource;
import org.kie.api.io.ResourceConfiguration;
import org.kie.api.io.ResourceType;
import org.kie.api.marshalling.ObjectMarshallingStrategy;
import org.kie.api.runtime.Environment;
import org.kie.api.runtime.KieSessionConfiguration;
import org.kie.api.runtime.conf.KieSessionOption;
import org.kie.api.runtime.manager.RegisterableItemsFactory;
import org.kie.api.task.UserGroupCallback;
import org.kie.internal.builder.DecisionTableConfiguration;
import org.kie.internal.builder.DecisionTableInputType;
import org.kie.internal.builder.KnowledgeBuilder;
import org.kie.internal.builder.KnowledgeBuilderError;
import org.kie.internal.builder.KnowledgeBuilderFactory;
import org.kie.internal.io.ResourceTypeImpl;
import org.kie.internal.runtime.conf.ForceEagerActivationOption;
import org.kie.internal.runtime.manager.Mapper;
import org.kie.internal.runtime.manager.RuntimeEnvironment;

public class SimpleRuntimeEnvironment
implements RuntimeEnvironment,
SchedulerProvider {
    protected boolean usePersistence;
    protected EntityManagerFactory emf;
    protected Map<String, Object> environmentEntries;
    protected Environment environment = EnvironmentFactory.newEnvironment();
    protected KieSessionConfiguration configuration;
    protected KieBase kbase;
    protected KnowledgeBuilder kbuilder;
    protected RegisterableItemsFactory registerableItemsFactory;
    protected Mapper mapper;
    protected UserGroupCallback userGroupCallback;
    protected GlobalSchedulerService schedulerService;
    protected ClassLoader classLoader;
    protected Properties sessionConfigProperties;

    public SimpleRuntimeEnvironment() {
        this((RegisterableItemsFactory)new SimpleRegisterableItemsFactory());
    }

    public SimpleRuntimeEnvironment(RegisterableItemsFactory registerableItemsFactory) {
        this.environmentEntries = new HashMap<String, Object>();
        this.kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        this.registerableItemsFactory = registerableItemsFactory;
    }

    public void init() {
        if (this.mapper == null) {
            this.mapper = new InMemoryMapper();
        }
    }

    public void addAsset(Resource resource, ResourceType type) {
        boolean replaced = false;
        if (resource.getSourcePath() != null) {
            String path = resource.getSourcePath();
            String typeStr = null;
            if (path.toLowerCase().endsWith(".csv")) {
                typeStr = DecisionTableInputType.CSV.toString();
            } else if (path.toLowerCase().endsWith(".xls")) {
                typeStr = DecisionTableInputType.XLS.toString();
            }
            if (typeStr != null) {
                String worksheetName = null;
                boolean replaceConfig = true;
                ResourceConfiguration config = resource.getConfiguration();
                if (config != null && config instanceof DecisionTableConfiguration) {
                    DecisionTableInputType realType = DecisionTableInputType.valueOf((String)typeStr);
                    if (((DecisionTableConfiguration)config).getInputType().equals((Object)realType)) {
                        replaceConfig = false;
                    } else {
                        worksheetName = ((DecisionTableConfiguration)config).getWorksheetName();
                    }
                }
                if (replaceConfig) {
                    Properties prop = new Properties();
                    prop.setProperty("kie.resource.conf.class", DecisionTableConfigurationImpl.class.getName());
                    prop.setProperty("drools.dt.type", typeStr);
                    if (worksheetName != null) {
                        prop.setProperty("drools.dt.worksheet", worksheetName);
                    }
                    ResourceConfiguration conf = ResourceTypeImpl.fromProperties((Properties)prop);
                    this.kbuilder.add(resource, type, conf);
                    replaced = true;
                }
            }
        }
        if (!replaced) {
            this.kbuilder.add(resource, type);
        }
        if (this.kbuilder.hasErrors()) {
            StringBuffer errorMessage = new StringBuffer();
            for (KnowledgeBuilderError error : this.kbuilder.getErrors()) {
                errorMessage.append(error.getMessage() + ",");
            }
            this.kbuilder.undo();
            throw new IllegalArgumentException("Cannot add asset: " + errorMessage.toString());
        }
    }

    public void addToEnvironment(String name, Object value) {
        this.environment.set(name, value);
        this.environmentEntries.put(name, value);
    }

    public void addToConfiguration(String name, String value) {
        if (this.sessionConfigProperties == null) {
            this.sessionConfigProperties = new Properties();
        }
        this.sessionConfigProperties.setProperty(name, value);
    }

    public KieBase getKieBase() {
        if (this.kbase == null) {
            this.kbase = this.kbuilder.newKnowledgeBase();
        }
        return this.kbase;
    }

    public Environment getEnvironmentTemplate() {
        return this.environment;
    }

    public Environment getEnvironment() {
        return this.copyEnvironment();
    }

    public KieSessionConfiguration getConfiguration() {
        KieSessionConfiguration config = null;
        config = this.sessionConfigProperties != null ? KieServices.Factory.get().newKieSessionConfiguration(this.sessionConfigProperties, this.classLoader) : KieServices.Factory.get().newKieSessionConfiguration(null, this.classLoader);
        config.setOption((KieSessionOption)ForceEagerActivationOption.YES);
        return config;
    }

    public boolean usePersistence() {
        return this.usePersistence;
    }

    public RegisterableItemsFactory getRegisterableItemsFactory() {
        return this.registerableItemsFactory;
    }

    public void close() {
    }

    protected void addIfPresent(String name, Environment copy) {
        Object value = this.environment.get(name);
        if (value != null) {
            copy.set(name, value);
        }
    }

    protected Environment copyEnvironment() {
        Environment copy = EnvironmentFactory.newEnvironment();
        this.addIfPresent("org.kie.api.persistence.jpa.EntityManagerFactory", copy);
        this.addIfPresent("org.kie.api.time.Calendars", copy);
        this.addIfPresent("org.kie.build.DateFormats", copy);
        this.addIfPresent("org.kie.Globals", copy);
        this.addIfPresent("org.kie.api.marshalling.ObjectMarshallingStrategies", copy);
        this.addIfPresent("org.kie.api.persistence.PersistenceContextManager", copy);
        this.addIfPresent("org.kie.api.persistence.TaskPersistenceContextManager", copy);
        this.addIfPresent("org.kie.transaction.TransactionManager", copy);
        this.addIfPresent("org.kie.transaction.TransactionSynchronizationRegistry", copy);
        this.addIfPresent("org.kie.transaction.Transaction", copy);
        this.addIfPresent("org.kie.transaction.local", copy);
        this.addIfPresent("org.kie.api.persistence.pessimistic", copy);
        if (this.usePersistence()) {
            ObjectMarshallingStrategy[] strategies = (ObjectMarshallingStrategy[])copy.get("org.kie.api.marshalling.ObjectMarshallingStrategies");
            ArrayList<ObjectMarshallingStrategy> listStrategies = new ArrayList<ObjectMarshallingStrategy>(Arrays.asList(strategies));
            listStrategies.add(0, (ObjectMarshallingStrategy)new ProcessInstanceResolverStrategy());
            strategies = new ObjectMarshallingStrategy[listStrategies.size()];
            copy.set("org.kie.api.marshalling.ObjectMarshallingStrategies", (Object)listStrategies.toArray(strategies));
        }
        this.addIfPresent("org.kie.api.persistence.jpa.AppScopedEntityManager", copy);
        this.addIfPresent("org.kie.api.persistence.jpa.CmdScopedEntityManager", copy);
        this.addIfPresent("IS_JTA_TRANSACTION", copy);
        this.addIfPresent("IS_TIMER_CMT", copy);
        this.addIfPresent("IS_SHARED_ENTITY_MANAGER", copy);
        this.addIfPresent("TRANSACTION_LOCK_ENABLED", copy);
        this.addIfPresent("IdentityProvider", copy);
        this.addIfPresent("jbpm.business.calendar", copy);
        if (!this.environmentEntries.isEmpty()) {
            for (Map.Entry<String, Object> entry : this.environmentEntries.entrySet()) {
                if (copy.get(entry.getKey()) != null) continue;
                copy.set(entry.getKey(), entry.getValue());
            }
        }
        return copy;
    }

    public Mapper getMapper() {
        return this.mapper;
    }

    public UserGroupCallback getUserGroupCallback() {
        return this.userGroupCallback;
    }

    public void setUserGroupCallback(UserGroupCallback userGroupCallback) {
        this.userGroupCallback = userGroupCallback;
    }

    public Properties getSessionConfigProperties() {
        return this.sessionConfigProperties;
    }

    public void setSessionConfigProperties(Properties sessionConfigProperties) {
        this.sessionConfigProperties = sessionConfigProperties;
    }

    public void setUsePersistence(boolean usePersistence) {
        this.usePersistence = usePersistence;
    }

    public void setKieBase(KieBase kbase) {
        this.kbase = kbase;
    }

    public void setMapper(Mapper mapper) {
        this.mapper = mapper;
    }

    @Override
    public GlobalSchedulerService getSchedulerService() {
        return this.schedulerService;
    }

    public void setSchedulerService(GlobalSchedulerService schedulerService) {
        this.schedulerService = schedulerService;
    }

    public void setRegisterableItemsFactory(RegisterableItemsFactory registerableItemsFactory) {
        this.registerableItemsFactory = registerableItemsFactory;
    }

    public EntityManagerFactory getEmf() {
        return this.emf;
    }

    public void setEmf(EntityManagerFactory emf) {
        this.emf = emf;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }
}

