/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.workitem;

import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.drools.core.process.core.datatype.DataType;
import org.drools.core.process.core.impl.ParameterDefinitionImpl;
import org.drools.core.util.ConfFileUtils;
import org.drools.core.util.MVELSafeHelper;
import org.jbpm.process.workitem.WorkDefinitionImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkItemRepository {
    private static final Logger logger = LoggerFactory.getLogger(WorkItemRepository.class);

    public static Map<String, WorkDefinitionImpl> getWorkDefinitions(String path) {
        HashMap<String, WorkDefinitionImpl> workDefinitions = new HashMap<String, WorkDefinitionImpl>();
        List<Map<String, Object>> workDefinitionsMaps = WorkItemRepository.getAllWorkDefinitionsMap(path);
        for (Map<String, Object> workDefinitionMap : workDefinitionsMaps) {
            if (workDefinitionMap == null) continue;
            WorkDefinitionImpl workDefinition = new WorkDefinitionImpl();
            workDefinition.setName((String)workDefinitionMap.get("name"));
            workDefinition.setDisplayName((String)workDefinitionMap.get("displayName"));
            workDefinition.setIcon((String)workDefinitionMap.get("icon"));
            workDefinition.setCustomEditor((String)workDefinitionMap.get("customEditor"));
            workDefinition.setCategory((String)workDefinitionMap.get("category"));
            workDefinition.setPath((String)workDefinitionMap.get("path"));
            workDefinition.setFile((String)workDefinitionMap.get("file"));
            workDefinition.setDocumentation((String)workDefinitionMap.get("documentation"));
            HashSet<ParameterDefinitionImpl> parameters = new HashSet<ParameterDefinitionImpl>();
            Map parameterMap = (Map)workDefinitionMap.get("parameters");
            if (parameterMap != null) {
                for (Map.Entry entry : parameterMap.entrySet()) {
                    parameters.add(new ParameterDefinitionImpl((String)entry.getKey(), (DataType)entry.getValue()));
                }
            }
            workDefinition.setParameters(parameters);
            HashSet<ParameterDefinitionImpl> results = new HashSet<ParameterDefinitionImpl>();
            Map resultMap = (Map)workDefinitionMap.get("results");
            if (resultMap != null) {
                for (Map.Entry entry : resultMap.entrySet()) {
                    results.add(new ParameterDefinitionImpl((String)entry.getKey(), (DataType)entry.getValue()));
                }
            }
            workDefinition.setResults(results);
            workDefinition.setDefaultHandler((String)workDefinitionMap.get("defaultHandler"));
            workDefinition.setDependencies(((List)workDefinitionMap.get("dependencies")).toArray(new String[0]));
            workDefinitions.put(workDefinition.getName(), workDefinition);
        }
        return workDefinitions;
    }

    private static List<Map<String, Object>> getAllWorkDefinitionsMap(String directory) {
        ArrayList<Map<String, Object>> workDefinitions = new ArrayList<Map<String, Object>>();
        for (String s : WorkItemRepository.getDirectories(directory)) {
            try {
                workDefinitions.addAll(WorkItemRepository.getAllWorkDefinitionsMap(directory + "/" + s));
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            workDefinitions.addAll(WorkItemRepository.getWorkDefinitionsMap(directory, s));
        }
        return workDefinitions;
    }

    private static String[] getDirectories(String path) {
        String content = null;
        try {
            content = ConfFileUtils.URLContentsToString((URL)new URL(path + "/index.conf"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (content == null) {
            return new String[0];
        }
        return content.split("\n");
    }

    private static List<Map<String, Object>> getWorkDefinitionsMap(String parentPath, String file) {
        String path = parentPath + "/" + file + "/" + file + ".wid";
        String content = null;
        try {
            content = ConfFileUtils.URLContentsToString((URL)new URL(path));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (content == null) {
            return new ArrayList<Map<String, Object>>();
        }
        try {
            List result = (List)MVELSafeHelper.getEvaluator().eval(content, new HashMap());
            for (Map wid : result) {
                wid.put("path", parentPath + "/" + file);
                wid.put("file", file + ".wid");
            }
            return result;
        }
        catch (Throwable t) {
            logger.error("Error occured while loading work definitions " + path, t);
            throw new RuntimeException("Could not parse work definitions " + path + ": " + t.getMessage());
        }
    }
}

