/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.builder;

import java.util.HashMap;
import java.util.Map;
import org.drools.compiler.compiler.ReturnValueDescr;
import org.drools.compiler.lang.descr.ProcessDescr;
import org.jbpm.process.builder.ProcessBuildContext;
import org.jbpm.process.builder.ProcessNodeBuilder;
import org.jbpm.process.builder.dialect.ProcessDialect;
import org.jbpm.process.builder.dialect.ProcessDialectRegistry;
import org.jbpm.process.core.ContextResolver;
import org.jbpm.process.instance.impl.ReturnValueConstraintEvaluator;
import org.jbpm.process.instance.impl.RuleConstraintEvaluator;
import org.jbpm.workflow.core.Constraint;
import org.jbpm.workflow.core.impl.ConnectionRef;
import org.jbpm.workflow.core.impl.ConstraintImpl;
import org.jbpm.workflow.core.impl.NodeImpl;
import org.jbpm.workflow.core.node.Split;
import org.kie.api.definition.process.Connection;
import org.kie.api.definition.process.Node;
import org.kie.api.definition.process.Process;

public class SplitNodeBuilder
implements ProcessNodeBuilder {
    @Override
    public void build(Process process, ProcessDescr processDescr, ProcessBuildContext context, Node node) {
        Split splitNode = (Split)node;
        if (splitNode.getType() != 2 && splitNode.getType() != 3) {
            return;
        }
        HashMap map = new HashMap(splitNode.getConstraints());
        for (Map.Entry entry : map.entrySet()) {
            ConnectionRef connection = (ConnectionRef)entry.getKey();
            ConstraintImpl constraint = (ConstraintImpl)entry.getValue();
            Connection outgoingConnection = null;
            for (Connection out : splitNode.getDefaultOutgoingConnections()) {
                if (!out.getToType().equals(connection.getToType()) || out.getTo().getId() != connection.getNodeId()) continue;
                outgoingConnection = out;
            }
            if (outgoingConnection == null) {
                throw new IllegalArgumentException("Could not find outgoing connection");
            }
            if (constraint == null && splitNode.isDefault(outgoingConnection)) continue;
            if (constraint != null && "rule".equals(constraint.getType())) {
                RuleConstraintEvaluator ruleConstraint = new RuleConstraintEvaluator();
                ruleConstraint.setDialect(constraint.getDialect());
                ruleConstraint.setName(constraint.getName());
                ruleConstraint.setPriority(constraint.getPriority());
                ruleConstraint.setDefault(constraint.isDefault());
                ruleConstraint.setType(constraint.getType());
                ruleConstraint.setConstraint(constraint.getConstraint());
                splitNode.setConstraint(outgoingConnection, (Constraint)ruleConstraint);
                continue;
            }
            if (constraint == null || !"code".equals(constraint.getType())) continue;
            ReturnValueConstraintEvaluator returnValueConstraint = new ReturnValueConstraintEvaluator();
            returnValueConstraint.setDialect(constraint.getDialect());
            returnValueConstraint.setName(constraint.getName());
            returnValueConstraint.setPriority(constraint.getPriority());
            returnValueConstraint.setDefault(constraint.isDefault());
            returnValueConstraint.setType(constraint.getType());
            returnValueConstraint.setConstraint(constraint.getConstraint());
            splitNode.setConstraint(outgoingConnection, (Constraint)returnValueConstraint);
            ReturnValueDescr returnValueDescr = new ReturnValueDescr();
            returnValueDescr.setText(constraint.getConstraint());
            ProcessDialect dialect = ProcessDialectRegistry.getDialect(constraint.getDialect());
            dialect.getReturnValueEvaluatorBuilder().build(context, returnValueConstraint, returnValueDescr, (ContextResolver)((NodeImpl)node));
        }
    }
}

