/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.console.ng.pr.backend.server;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.jbpm.console.ng.pr.model.ProcessVariableSummary;
import org.jbpm.services.api.model.VariableDesc;

public class VariableHelper {
    private static final List<String> excludedVariables = Arrays.asList("processId");

    public static Collection<ProcessVariableSummary> adaptCollection(Collection<VariableDesc> variables) {
        ArrayList<ProcessVariableSummary> variablesSummary = new ArrayList<ProcessVariableSummary>();
        for (VariableDesc v : variables) {
            variablesSummary.add(new ProcessVariableSummary(v.getVariableId(), v.getVariableInstanceId(), v.getProcessInstanceId().longValue(), v.getOldValue(), v.getNewValue(), v.getDataTimeStamp().getTime(), ""));
        }
        return variablesSummary;
    }

    public static Collection<ProcessVariableSummary> adaptCollection(Collection<VariableDesc> variables, Map<String, String> properties, long processInstanceId) {
        ArrayList<ProcessVariableSummary> variablesSummary = new ArrayList<ProcessVariableSummary>();
        for (VariableDesc variableDesc : variables) {
            if (excludedVariables.contains(variableDesc.getVariableId())) continue;
            String type = properties.remove(variableDesc.getVariableId());
            variablesSummary.add(new ProcessVariableSummary(variableDesc.getVariableId(), variableDesc.getVariableInstanceId(), variableDesc.getProcessInstanceId().longValue(), variableDesc.getOldValue(), variableDesc.getNewValue(), variableDesc.getDataTimeStamp().getTime(), type));
        }
        if (!properties.isEmpty()) {
            for (Map.Entry entry : properties.entrySet()) {
                variablesSummary.add(new ProcessVariableSummary((String)entry.getKey(), "", processInstanceId, "", "", new Date().getTime(), (String)entry.getValue()));
            }
        }
        return variablesSummary;
    }

    public static ProcessVariableSummary adapt(VariableDesc v) {
        return new ProcessVariableSummary(v.getVariableId(), v.getVariableInstanceId(), v.getProcessInstanceId().longValue(), v.getOldValue(), v.getNewValue(), v.getDataTimeStamp().getTime(), "");
    }
}

