/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.console.ng.pr.backend.server;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.jboss.errai.bus.server.annotations.Service;
import org.jbpm.console.ng.ga.model.QueryFilter;
import org.jbpm.console.ng.pr.backend.server.VariableHelper;
import org.jbpm.console.ng.pr.model.ProcessVariableKey;
import org.jbpm.console.ng.pr.model.ProcessVariableSummary;
import org.jbpm.console.ng.pr.service.ProcessVariablesService;
import org.jbpm.services.api.DefinitionService;
import org.jbpm.services.api.RuntimeDataService;
import org.uberfire.paging.PageResponse;

@Service
@ApplicationScoped
public class ProcessVariablesServiceImpl
implements ProcessVariablesService {
    @Inject
    private RuntimeDataService dataService;
    @Inject
    private DefinitionService bpmn2Service;

    public PageResponse<ProcessVariableSummary> getData(QueryFilter filter) {
        PageResponse response = new PageResponse();
        Long processInstanceId = null;
        String processId = "";
        String deploymentId = "";
        if (filter.getParams() != null) {
            processInstanceId = Long.valueOf((String)filter.getParams().get("processInstanceId"));
            processId = (String)filter.getParams().get("processDefId");
            deploymentId = (String)filter.getParams().get("deploymentId");
        }
        org.kie.internal.query.QueryFilter qf = new org.kie.internal.query.QueryFilter(filter.getOffset().intValue(), filter.getCount() + 1, filter.getOrderBy(), filter.isAscending().booleanValue());
        HashMap<String, String> properties = new HashMap<String, String>(this.bpmn2Service.getProcessVariables(deploymentId, processId));
        Collection<ProcessVariableSummary> processVariables = VariableHelper.adaptCollection(this.dataService.getVariablesCurrentState(processInstanceId.longValue()), properties, processInstanceId);
        ArrayList<ProcessVariableSummary> processVariablesSums = new ArrayList<ProcessVariableSummary>(processVariables.size());
        for (ProcessVariableSummary pv : processVariables) {
            if (filter.getParams().get("textSearch") == null || ((String)filter.getParams().get("textSearch")).isEmpty()) {
                processVariablesSums.add(pv);
                continue;
            }
            if (!pv.getVariableId().toLowerCase().contains((String)filter.getParams().get("textSearch"))) continue;
            processVariablesSums.add(pv);
        }
        response.setStartRowIndex(filter.getOffset().intValue());
        response.setTotalRowSize(processVariablesSums.size() - 1);
        if (processVariablesSums.size() > filter.getCount()) {
            response.setTotalRowSizeExact(false);
        } else {
            response.setTotalRowSizeExact(true);
        }
        if (!processVariablesSums.isEmpty() && processVariablesSums.size() > filter.getCount() + filter.getOffset()) {
            response.setPageRowList(new ArrayList(processVariablesSums.subList(filter.getOffset(), filter.getOffset() + filter.getCount())));
            response.setLastPage(false);
        } else {
            response.setPageRowList(new ArrayList(processVariablesSums));
            response.setLastPage(true);
        }
        return response;
    }

    public ProcessVariableSummary getItem(ProcessVariableKey key) {
        return null;
    }
}

