/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.casemgmt.impl.command;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.drools.core.ClassObjectFilter;
import org.drools.core.command.impl.RegistryContext;
import org.jbpm.casemgmt.api.auth.AuthorizationManager;
import org.jbpm.casemgmt.api.model.instance.CaseFileInstance;
import org.jbpm.casemgmt.impl.command.CaseCommand;
import org.jbpm.casemgmt.impl.event.CaseEventSupport;
import org.jbpm.casemgmt.impl.model.instance.CaseFileInstanceImpl;
import org.kie.api.runtime.Context;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.ObjectFilter;
import org.kie.api.runtime.rule.FactHandle;
import org.kie.internal.identity.IdentityProvider;

public class AddDataCaseFileInstanceCommand
extends CaseCommand<Void> {
    private static final long serialVersionUID = 6345222909719335953L;
    private Map<String, Object> parameters;
    private AuthorizationManager authorizationManager;
    private List<String> accessRestriction;

    public AddDataCaseFileInstanceCommand(IdentityProvider identityProvider, Map<String, Object> parameters, List<String> accessRestriction, AuthorizationManager authorizationManager) {
        super(identityProvider);
        this.parameters = parameters;
        this.authorizationManager = authorizationManager;
        this.accessRestriction = accessRestriction;
    }

    public Void execute(Context context) {
        KieSession ksession = (KieSession)((RegistryContext)context).lookup(KieSession.class);
        Collection caseFiles = ksession.getObjects((ObjectFilter)new ClassObjectFilter(CaseFileInstance.class));
        if (caseFiles.size() != 1) {
            throw new IllegalStateException("Not able to find distinct case file - found case files " + caseFiles.size());
        }
        CaseFileInstance caseFile = (CaseFileInstance)caseFiles.iterator().next();
        this.authorizationManager.checkDataAuthorization(caseFile.getCaseId(), caseFile, this.parameters.keySet());
        FactHandle factHandle = ksession.getFactHandle((Object)caseFile);
        CaseEventSupport caseEventSupport = this.getCaseEventSupport(context);
        caseEventSupport.fireBeforeCaseDataAdded(caseFile.getCaseId(), caseFile, caseFile.getDefinitionId(), this.parameters);
        caseFile.addAll(this.parameters);
        for (String name : this.parameters.keySet()) {
            if (this.accessRestriction != null) {
                ((CaseFileInstanceImpl)caseFile).addDataAccessRestriction(name, this.accessRestriction);
                continue;
            }
            ((CaseFileInstanceImpl)caseFile).removeDataAccessRestriction(name);
        }
        ksession.update(factHandle, (Object)caseFile);
        this.triggerRules(ksession);
        caseEventSupport.fireAfterCaseDataAdded(caseFile.getCaseId(), caseFile, caseFile.getDefinitionId(), this.parameters);
        return null;
    }
}

