/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.casemgmt.impl.audit;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jbpm.casemgmt.api.event.CaseDataEvent;
import org.jbpm.casemgmt.api.event.CaseEventListener;
import org.jbpm.casemgmt.api.event.CaseReopenEvent;
import org.jbpm.casemgmt.api.event.CaseRoleAssignmentEvent;
import org.jbpm.casemgmt.api.event.CaseStartEvent;
import org.jbpm.casemgmt.api.model.instance.CaseFileInstance;
import org.jbpm.casemgmt.api.model.instance.CaseRoleInstance;
import org.jbpm.casemgmt.impl.audit.CaseFileDataLog;
import org.jbpm.casemgmt.impl.audit.CaseRoleAssignmentLog;
import org.jbpm.casemgmt.impl.model.instance.CaseFileInstanceImpl;
import org.jbpm.shared.services.impl.TransactionalCommandService;
import org.jbpm.shared.services.impl.commands.MergeObjectCommand;
import org.jbpm.shared.services.impl.commands.PersistObjectCommand;
import org.jbpm.shared.services.impl.commands.QueryStringCommand;
import org.jbpm.shared.services.impl.commands.UpdateStringCommand;
import org.kie.api.command.Command;
import org.kie.api.task.model.OrganizationalEntity;
import org.kie.internal.runtime.Cacheable;
import org.kie.internal.task.api.TaskModelProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CaseInstanceAuditEventListener
implements CaseEventListener,
Cacheable {
    private static final Logger logger = LoggerFactory.getLogger(CaseInstanceAuditEventListener.class);
    private static final String UPDATE_CASE_PROCESS_INST_ID_QUERY = "update CaseRoleAssignmentLog set processInstanceId =:piID where caseId =:caseId";
    private static final String DELETE_CASE_ROLE_ASSIGNMENT_QUERY = "delete from CaseRoleAssignmentLog where caseId =:caseId and roleName =:role and entityId =:entity";
    private static final String FIND_CASE_PROCESS_INST_ID_QUERY = "select processInstanceId from ProcessInstanceLog where correlationKey =:caseId";
    private static final String FIND_CASE_DATA_QUERY = "select itemName from CaseFileDataLog where caseId =:caseId";
    private static final String FIND_CASE_DATA_BY_NAME_QUERY = "select cfdl from CaseFileDataLog cfdl where cfdl.caseId =:caseId and cfdl.itemName =:itemName";
    private static final String DELETE_CASE_DATA_BY_NAME_QUERY = "delete from CaseFileDataLog where caseId =:caseId and itemName in (:itemNames)";
    private TransactionalCommandService commandService;

    public CaseInstanceAuditEventListener(TransactionalCommandService commandService) {
        this.commandService = commandService;
    }

    public void afterCaseStarted(CaseStartEvent event) {
        CaseFileInstance caseFile = event.getCaseFile();
        if (caseFile == null) {
            return;
        }
        Collection<CaseRoleInstance> caseRoleAssignments = ((CaseFileInstanceImpl)caseFile).getAssignments();
        if (caseRoleAssignments != null && !caseRoleAssignments.isEmpty()) {
            for (CaseRoleInstance roleAssignment : caseRoleAssignments) {
                logger.debug("Role {} has following assignments {}", (Object)roleAssignment.getRoleName(), (Object)roleAssignment.getRoleAssignments());
                if (roleAssignment.getRoleAssignments() == null || roleAssignment.getRoleAssignments().isEmpty()) continue;
                ArrayList objects = new ArrayList();
                roleAssignment.getRoleAssignments().forEach(entity -> {
                    CaseRoleAssignmentLog assignmentLog = new CaseRoleAssignmentLog(event.getProcessInstanceId(), event.getCaseId(), roleAssignment.getRoleName(), (OrganizationalEntity)entity);
                    objects.add(assignmentLog);
                });
                this.commandService.execute((Command)new PersistObjectCommand(objects.toArray()));
            }
        } else {
            CaseRoleAssignmentLog assignmentLog = new CaseRoleAssignmentLog(event.getProcessInstanceId(), event.getCaseId(), "*", (OrganizationalEntity)TaskModelProvider.getFactory().newGroup("_public_"));
            this.commandService.execute((Command)new PersistObjectCommand(new Object[]{assignmentLog}));
        }
        Map initialData = caseFile.getData();
        if (initialData.isEmpty()) {
            return;
        }
        ArrayList insert = new ArrayList();
        initialData.forEach((name, value) -> {
            if (value != null) {
                CaseFileDataLog caseFileDataLog = new CaseFileDataLog(event.getCaseId(), caseFile.getDefinitionId(), (String)name);
                insert.add(caseFileDataLog);
                caseFileDataLog.setItemType(value.getClass().getName());
                caseFileDataLog.setItemValue(value.toString());
                caseFileDataLog.setLastModified(new Date());
                caseFileDataLog.setLastModifiedBy(event.getUser());
            }
        });
        this.commandService.execute((Command)new PersistObjectCommand(insert.toArray()));
    }

    public void afterCaseReopen(CaseReopenEvent event) {
        logger.debug("Updating process instance id ({})in case assignment log for case id {}", (Object)event.getProcessInstanceId(), (Object)event.getCaseId());
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("piID", event.getProcessInstanceId());
        parameters.put("caseId", event.getCaseId());
        UpdateStringCommand updateCommand = new UpdateStringCommand(UPDATE_CASE_PROCESS_INST_ID_QUERY, parameters);
        int updated = (Integer)this.commandService.execute((Command)updateCommand);
        logger.debug("Updated {} role assignment entries for case id {}", (Object)updated, (Object)event.getCaseId());
    }

    public void afterCaseRoleAssignmentAdded(CaseRoleAssignmentEvent event) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("caseId", event.getCaseId());
        QueryStringCommand queryCommand = new QueryStringCommand(FIND_CASE_PROCESS_INST_ID_QUERY, parameters);
        List processInstanceId = (List)this.commandService.execute((Command)queryCommand);
        if (processInstanceId.isEmpty()) {
            return;
        }
        CaseRoleAssignmentLog assignmentLog = new CaseRoleAssignmentLog((Long)processInstanceId.get(0), event.getCaseId(), event.getRole(), event.getEntity());
        this.commandService.execute((Command)new PersistObjectCommand(new Object[]{assignmentLog}));
    }

    public void afterCaseRoleAssignmentRemoved(CaseRoleAssignmentEvent event) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("caseId", event.getCaseId());
        parameters.put("role", event.getRole());
        parameters.put("entity", event.getEntity().getId());
        UpdateStringCommand updateCommand = new UpdateStringCommand(DELETE_CASE_ROLE_ASSIGNMENT_QUERY, parameters);
        this.commandService.execute((Command)updateCommand);
        logger.debug("Removed {} role assignment for entity {} for case id {}", new Object[]{event.getRole(), event.getEntity(), event.getCaseId()});
    }

    public void afterCaseDataAdded(CaseDataEvent event) {
        Map addedData = event.getData();
        if (addedData.isEmpty()) {
            return;
        }
        ArrayList insert = new ArrayList();
        ArrayList update = new ArrayList();
        List<String> currentCaseData = this.currentCaseData(event.getCaseId());
        addedData.forEach((name, value) -> {
            if (value != null) {
                CaseFileDataLog caseFileDataLog = null;
                if (currentCaseData.contains(name)) {
                    logger.debug("Case instance {} has already stored log value for {} thus it's going to be updated", (Object)event.getCaseId(), name);
                    caseFileDataLog = this.caseFileDataByName(event.getCaseId(), (String)name);
                    update.add(caseFileDataLog);
                } else {
                    logger.debug("Case instance {} has no log value for {} thus it's going to be inserted", (Object)event.getCaseId(), name);
                    caseFileDataLog = new CaseFileDataLog(event.getCaseId(), event.getDefinitionId(), (String)name);
                    insert.add(caseFileDataLog);
                }
                caseFileDataLog.setItemType(value.getClass().getName());
                caseFileDataLog.setItemValue(value.toString());
                caseFileDataLog.setLastModified(new Date());
                caseFileDataLog.setLastModifiedBy(event.getUser());
            }
        });
        this.commandService.execute((Command)new PersistObjectCommand(insert.toArray()));
        this.commandService.execute((Command)new MergeObjectCommand(update.toArray()));
    }

    public void afterCaseDataRemoved(CaseDataEvent event) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("caseId", event.getCaseId());
        parameters.put("itemNames", new ArrayList(event.getData().keySet()));
        UpdateStringCommand updateCommand = new UpdateStringCommand(DELETE_CASE_DATA_BY_NAME_QUERY, parameters);
        this.commandService.execute((Command)updateCommand);
    }

    public void close() {
    }

    protected List<String> currentCaseData(String caseId) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("caseId", caseId);
        QueryStringCommand queryCommand = new QueryStringCommand(FIND_CASE_DATA_QUERY, parameters);
        List caseDataLog = (List)this.commandService.execute((Command)queryCommand);
        return caseDataLog;
    }

    protected CaseFileDataLog caseFileDataByName(String caseId, String name) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("caseId", caseId);
        parameters.put("itemName", name);
        QueryStringCommand queryCommand = new QueryStringCommand(FIND_CASE_DATA_BY_NAME_QUERY, parameters);
        List caseDataLog = (List)this.commandService.execute((Command)queryCommand);
        return (CaseFileDataLog)caseDataLog.get(0);
    }
}

