/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.casemgmt.impl;

import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Stream;
import org.jbpm.casemgmt.api.auth.AuthorizationManager;
import org.jbpm.casemgmt.api.model.instance.CaseFileInstance;
import org.jbpm.casemgmt.api.model.instance.CommentInstance;
import org.jbpm.casemgmt.impl.model.instance.CaseFileInstanceImpl;
import org.jbpm.casemgmt.impl.model.instance.CommentInstanceImpl;
import org.jbpm.shared.services.impl.TransactionalCommandService;
import org.jbpm.shared.services.impl.commands.QueryNameCommand;
import org.kie.api.command.Command;
import org.kie.internal.identity.IdentityProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthorizationManagerImpl
implements AuthorizationManager {
    private static final Logger logger = LoggerFactory.getLogger(AuthorizationManagerImpl.class);
    private static final String NO_ACCESS_MSG = "User {0} is not authorized to access case {1}";
    private static final String NO_AUTH_OPER_MSG = "User {0} is not authorized to {1} on case {2}";
    private static final String NO_AUTH_TO_DATA = "User {0} does not have access to data item named {1} in case {2}";
    private static final String NO_AUTH_TO_COMMENT = "User {0} does not have access to comment {1} in case {2}";
    private IdentityProvider identityProvider;
    private TransactionalCommandService commandService;
    private boolean enabled = Boolean.parseBoolean(System.getProperty("org.jbpm.cases.auth.enabled", "true"));
    private Map<AuthorizationManager.ProtectedOperation, List<String>> operationAuthorization = new HashMap<AuthorizationManager.ProtectedOperation, List<String>>();

    public AuthorizationManagerImpl(IdentityProvider identityProvider, TransactionalCommandService commandService) {
        this.identityProvider = identityProvider;
        this.commandService = commandService;
        this.buildAuthorizationConfig();
    }

    public void checkAuthorization(String caseId) throws SecurityException {
        if (!this.isEnabled()) {
            return;
        }
        logger.debug("Checking authorization to case {} for user {}", (Object)caseId, (Object)this.identityProvider.getName());
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("caseId", caseId);
        List authorizedEntities = (List)this.commandService.execute((Command)new QueryNameCommand("getAuthorizationToCaseInstance", params));
        this.verifyAuthorization(caseId, authorizedEntities, MessageFormat.format(NO_ACCESS_MSG, this.identityProvider.getName(), caseId));
    }

    public void checkOperationAuthorization(String caseId, AuthorizationManager.ProtectedOperation operation) throws SecurityException {
        List<String> rolesForOperation = this.operationAuthorization.get(operation);
        if (rolesForOperation == null || rolesForOperation.isEmpty()) {
            logger.debug("No restrictions defined for operation {}", (Object)operation);
            this.checkAuthorization(caseId);
            return;
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("caseId", caseId);
        params.put("roles", rolesForOperation);
        List authorizedEntities = (List)this.commandService.execute((Command)new QueryNameCommand("getAuthorizationToCaseInstanceByRole", params));
        this.verifyAuthorization(caseId, authorizedEntities, MessageFormat.format(NO_AUTH_OPER_MSG, this.identityProvider.getName(), operation, caseId));
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    protected void buildAuthorizationConfig() {
        Properties loaded = new Properties();
        InputStream configuration = this.getClass().getResourceAsStream("/case-authorization.properties");
        if (configuration != null) {
            try {
                loaded.load(configuration);
            }
            catch (IOException e) {
                logger.error("Error loading case autorization config from file due to {}", (Object)e.getMessage(), (Object)e);
            }
        }
        Stream.of(AuthorizationManager.ProtectedOperation.values()).forEach(operation -> {
            ArrayList<String> roles = new ArrayList<String>();
            String grantedRoles = loaded.getProperty(operation.toString());
            if (grantedRoles != null) {
                roles.addAll(Arrays.asList(grantedRoles.split(",")));
            }
            this.operationAuthorization.put((AuthorizationManager.ProtectedOperation)operation, (List<String>)roles);
        });
    }

    protected void verifyAuthorization(String caseId, List<String> authorizedEntities, String errorMessage) {
        logger.debug("Case {} authorization set is {}", (Object)caseId, authorizedEntities);
        if (authorizedEntities.isEmpty()) {
            logger.debug("Not access restrictions defined for case {}", (Object)caseId);
            return;
        }
        List<String> callerAuthorization = this.collectUserAuthInfo();
        logger.debug("Caller authorization set is {}", callerAuthorization);
        boolean isAuthorized = callerAuthorization.stream().anyMatch(entity -> authorizedEntities.contains(entity));
        if (!isAuthorized) {
            logger.debug("User {} not authorized to access case {}", (Object)this.identityProvider.getName(), (Object)caseId);
            throw new SecurityException(errorMessage);
        }
        logger.debug("User {} authorized to access case {}", (Object)this.identityProvider.getName(), (Object)caseId);
    }

    protected List<String> collectUserAuthInfo() {
        ArrayList<String> entities = new ArrayList<String>();
        entities.add(this.identityProvider.getName());
        entities.addAll(this.identityProvider.getRoles());
        entities.add("_public_");
        return entities;
    }

    public Map<String, Object> filterByDataAuthorization(String caseId, CaseFileInstance caseFileInstance, Map<String, Object> data) {
        if (data == null || data.isEmpty()) {
            logger.debug("No data to be filtered");
            return data;
        }
        Map<String, List<String>> accessRestrictions = ((CaseFileInstanceImpl)caseFileInstance).getAccessRestrictions();
        if (accessRestrictions == null || accessRestrictions.isEmpty()) {
            logger.debug("Case {} does not define any data restrictions returning unfiltered map", (Object)caseId);
            return data;
        }
        List<String> callerAuthorization = this.collectUserAuthInfo();
        logger.debug("Caller authorization set is {}", callerAuthorization);
        List<String> callerCaseRoles = this.getCallerRoles(caseFileInstance, callerAuthorization);
        logger.debug("Caller case role set is {}", callerCaseRoles);
        HashMap<String, Object> filteredData = new HashMap<String, Object>(data);
        for (Map.Entry<String, List<String>> entry : accessRestrictions.entrySet()) {
            List<String> requiredRoles = entry.getValue();
            if (requiredRoles.isEmpty() || requiredRoles.stream().anyMatch(role -> callerCaseRoles.contains(role))) {
                logger.debug("Caller {} has access to data item named {}", (Object)this.identityProvider.getName(), (Object)entry.getKey());
                continue;
            }
            logger.debug("Caller {} does not have access to data item named {}, required roles are {} and caller has {}", new Object[]{this.identityProvider.getName(), entry.getKey(), requiredRoles, callerCaseRoles});
            filteredData.remove(entry.getKey());
        }
        return filteredData;
    }

    public void checkDataAuthorization(String caseId, CaseFileInstance caseFileInstance, Collection<String> dataNames) {
        if (dataNames == null || dataNames.isEmpty()) {
            logger.debug("No data to be checked");
            return;
        }
        Map<String, List<String>> accessRestrictions = ((CaseFileInstanceImpl)caseFileInstance).getAccessRestrictions();
        if (accessRestrictions == null || accessRestrictions.isEmpty()) {
            logger.debug("Case {} does not define any data restrictions", (Object)caseId);
            return;
        }
        List<String> callerAuthorization = this.collectUserAuthInfo();
        logger.debug("Caller {} authorization set is {}", (Object)this.identityProvider.getName(), callerAuthorization);
        List<String> callerCaseRoles = this.getCallerRoles(caseFileInstance, callerAuthorization);
        logger.debug("Caller {} case role set is {}", (Object)this.identityProvider.getName(), callerCaseRoles);
        for (Map.Entry<String, List<String>> entry : accessRestrictions.entrySet()) {
            if (!dataNames.contains(entry.getKey())) continue;
            List<String> requiredRoles = entry.getValue();
            if (requiredRoles.isEmpty() || requiredRoles.stream().anyMatch(role -> callerCaseRoles.contains(role))) {
                logger.debug("Caller has access to data item named {}", (Object)entry.getKey());
                continue;
            }
            logger.warn("User {} does not have access to data item {} in case {}, required roles are {} and user has {}", new Object[]{this.identityProvider.getName(), entry.getKey(), caseId, requiredRoles, callerCaseRoles});
            throw new SecurityException(MessageFormat.format(NO_AUTH_TO_DATA, this.identityProvider.getName(), entry.getKey(), caseId, requiredRoles, callerCaseRoles));
        }
    }

    public List<CommentInstance> filterByCommentAuthorization(String caseId, CaseFileInstance caseFileInstance, List<CommentInstance> comments) {
        if (comments == null || comments.isEmpty()) {
            logger.debug("No comments to be filtered");
            return comments;
        }
        List<String> callerAuthorization = this.collectUserAuthInfo();
        logger.debug("Caller {} authorization set is {}", (Object)this.identityProvider.getName(), callerAuthorization);
        List<String> callerCaseRoles = this.getCallerRoles(caseFileInstance, callerAuthorization);
        logger.debug("Caller {} case role set is {}", (Object)this.identityProvider.getName(), callerCaseRoles);
        ArrayList<CommentInstance> filteredComments = new ArrayList<CommentInstance>(comments);
        for (CommentInstance commentInstance : comments) {
            CommentInstanceImpl comment = (CommentInstanceImpl)commentInstance;
            List<String> requiredRoles = comment.getRestrictedTo();
            if (requiredRoles == null || requiredRoles.isEmpty()) continue;
            if (requiredRoles.isEmpty() || requiredRoles.stream().anyMatch(role -> callerCaseRoles.contains(role))) {
                logger.debug("Caller {} has access to comment {}", (Object)this.identityProvider.getName(), (Object)comment.getId());
                continue;
            }
            logger.debug("Caller {} does not have access to comment {}", (Object)this.identityProvider.getName(), (Object)comment.getId());
            filteredComments.remove(comment);
        }
        return filteredComments;
    }

    public void checkCommentAuthorization(String caseId, CaseFileInstance caseFileInstance, CommentInstance commentInstance) {
        CommentInstanceImpl comment = (CommentInstanceImpl)commentInstance;
        if (comment.getRestrictedTo() == null || comment.getRestrictedTo().isEmpty()) {
            return;
        }
        List<String> callerAuthorization = this.collectUserAuthInfo();
        logger.debug("Caller {} authorization set is {}", (Object)this.identityProvider.getName(), callerAuthorization);
        List<String> callerCaseRoles = this.getCallerRoles(caseFileInstance, callerAuthorization);
        logger.debug("Caller {} case role set is {}", (Object)this.identityProvider.getName(), callerCaseRoles);
        List<String> requiredRoles = comment.getRestrictedTo();
        if (requiredRoles.isEmpty() || requiredRoles.stream().anyMatch(role -> callerCaseRoles.contains(role))) {
            logger.debug("Caller has access to comment {}", (Object)comment.getId());
            return;
        }
        logger.warn("User {} does not have access to comment {} in case {}, required roles are {} and user has {}", new Object[]{this.identityProvider.getName(), comment.getId(), caseId, requiredRoles, callerCaseRoles});
        throw new SecurityException(MessageFormat.format(NO_AUTH_TO_COMMENT, this.identityProvider.getName(), comment.getId(), caseId));
    }

    protected List<String> getCallerRoles(CaseFileInstance caseFileInstance, List<String> callerAuthorization) {
        List<String> callerRoles = ((CaseFileInstanceImpl)caseFileInstance).getRolesForOrgEntities(callerAuthorization);
        callerRoles.add("_public_");
        return callerRoles;
    }
}

