/*
 * JBoss, Home of Professional Open Source
 * Copyright 2008, Red Hat, Inc., and individual contributors
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * http://www.apache.org/licenses/LICENSE-2.0
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.jboss.weld.exceptions;

import java.io.Serializable;

/**
 * Simple message object that just contains a String already formatted
 * and localized.
 *
 * @author David Allen
 */
public class WeldExceptionStringMessage implements Serializable, WeldExceptionMessage {

    private static final long serialVersionUID = 2L;

    /**
     * The string version of the message. This is only used when the original
     * message from a wrapped exception is being used. Since it is already
     * localized, it will simply be stored here and used as the message.
     */
    private String message;

    /**
     * <p>
     * Creates a new exception message initialized to a static message. Use this
     * only for messages generated by third-party software, i.e., those which do
     * not use enumerated message keys.
     * </p>
     *
     * @param message the static message
     */
    public WeldExceptionStringMessage(String message) {
        // This will not be further localized
        this.message = message;
    }

    /*
     * (non-Javadoc)
     *
     * @see org.jboss.weld.exceptions.WeldExceptionMessage#getAsString()
     */
    public String getAsString() {
        return message;
    }
}
