/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.manager;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Member;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.regex.Pattern;
import javax.el.ELResolver;
import javax.el.ExpressionFactory;
import javax.enterprise.context.BeforeDestroyed;
import javax.enterprise.context.Dependent;
import javax.enterprise.context.Destroyed;
import javax.enterprise.context.Initialized;
import javax.enterprise.context.spi.Context;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.event.Event;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.spi.Annotated;
import javax.enterprise.inject.spi.AnnotatedField;
import javax.enterprise.inject.spi.AnnotatedMember;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.AnnotatedParameter;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanAttributes;
import javax.enterprise.inject.spi.BeforeShutdown;
import javax.enterprise.inject.spi.Decorator;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.inject.spi.InjectionTarget;
import javax.enterprise.inject.spi.InjectionTargetFactory;
import javax.enterprise.inject.spi.InterceptionFactory;
import javax.enterprise.inject.spi.InterceptionType;
import javax.enterprise.inject.spi.Interceptor;
import javax.enterprise.inject.spi.ObserverMethod;
import javax.enterprise.inject.spi.PassivationCapable;
import javax.enterprise.inject.spi.Prioritized;
import javax.enterprise.inject.spi.ProcessInjectionPoint;
import javax.enterprise.inject.spi.ProcessInjectionTarget;
import javax.enterprise.inject.spi.ProducerFactory;
import javax.enterprise.util.TypeLiteral;
import org.jboss.weld.Container;
import org.jboss.weld.annotated.AnnotatedTypeValidator;
import org.jboss.weld.annotated.enhanced.EnhancedAnnotated;
import org.jboss.weld.annotated.enhanced.EnhancedAnnotatedField;
import org.jboss.weld.annotated.enhanced.EnhancedAnnotatedParameter;
import org.jboss.weld.annotated.enhanced.EnhancedAnnotatedType;
import org.jboss.weld.annotated.slim.SlimAnnotatedType;
import org.jboss.weld.bean.AbstractClassBean;
import org.jboss.weld.bean.AbstractProducerBean;
import org.jboss.weld.bean.ContextualInstance;
import org.jboss.weld.bean.NewBean;
import org.jboss.weld.bean.RIBean;
import org.jboss.weld.bean.SessionBean;
import org.jboss.weld.bean.SyntheticBeanFactory;
import org.jboss.weld.bean.WeldBean;
import org.jboss.weld.bean.attributes.BeanAttributesFactory;
import org.jboss.weld.bean.builtin.AbstractBuiltInBean;
import org.jboss.weld.bean.builtin.ExtensionBean;
import org.jboss.weld.bean.builtin.InstanceImpl;
import org.jboss.weld.bean.proxy.ClientProxyProvider;
import org.jboss.weld.bean.proxy.DecorationHelper;
import org.jboss.weld.bootstrap.SpecializationAndEnablementRegistry;
import org.jboss.weld.bootstrap.Validator;
import org.jboss.weld.bootstrap.WeldUnusedMetadataExtension;
import org.jboss.weld.bootstrap.api.Environment;
import org.jboss.weld.bootstrap.api.ServiceRegistry;
import org.jboss.weld.bootstrap.enablement.ModuleEnablement;
import org.jboss.weld.bootstrap.events.ContainerLifecycleEvents;
import org.jboss.weld.config.ConfigurationKey;
import org.jboss.weld.config.WeldConfiguration;
import org.jboss.weld.contexts.CreationalContextImpl;
import org.jboss.weld.contexts.PassivatingContextWrapper;
import org.jboss.weld.contexts.WeldCreationalContext;
import org.jboss.weld.ejb.spi.EjbDescriptor;
import org.jboss.weld.event.ContainerLifecycleEventObserverMethod;
import org.jboss.weld.event.EventImpl;
import org.jboss.weld.event.EventMetadataImpl;
import org.jboss.weld.event.FastEvent;
import org.jboss.weld.event.GlobalObserverNotifierService;
import org.jboss.weld.event.ObserverMethodImpl;
import org.jboss.weld.event.ObserverNotifier;
import org.jboss.weld.events.WeldEvent;
import org.jboss.weld.exceptions.DefinitionException;
import org.jboss.weld.exceptions.DeploymentException;
import org.jboss.weld.exceptions.IllegalArgumentException;
import org.jboss.weld.exceptions.InjectionException;
import org.jboss.weld.inject.WeldInstance;
import org.jboss.weld.injection.CurrentInjectionPoint;
import org.jboss.weld.injection.EmptyInjectionPoint;
import org.jboss.weld.injection.InterceptionFactoryImpl;
import org.jboss.weld.injection.ThreadLocalStack;
import org.jboss.weld.injection.attributes.FieldInjectionPointAttributes;
import org.jboss.weld.injection.attributes.InferringFieldInjectionPointAttributes;
import org.jboss.weld.injection.attributes.InferringParameterInjectionPointAttributes;
import org.jboss.weld.injection.attributes.ParameterInjectionPointAttributes;
import org.jboss.weld.injection.producer.WeldInjectionTargetBuilderImpl;
import org.jboss.weld.interceptor.reader.InterceptorMetadataReader;
import org.jboss.weld.interceptor.spi.model.InterceptionModel;
import org.jboss.weld.logging.BeanManagerLogger;
import org.jboss.weld.logging.BootstrapLogger;
import org.jboss.weld.manager.BeanManagerLookupService;
import org.jboss.weld.manager.BeanTransform;
import org.jboss.weld.manager.FieldProducerFactory;
import org.jboss.weld.manager.InjectionTargetFactoryImpl;
import org.jboss.weld.manager.MethodProducerFactory;
import org.jboss.weld.manager.api.WeldInjectionTargetBuilder;
import org.jboss.weld.manager.api.WeldInjectionTargetFactory;
import org.jboss.weld.manager.api.WeldManager;
import org.jboss.weld.metadata.cache.InterceptorBindingModel;
import org.jboss.weld.metadata.cache.MetaAnnotationStore;
import org.jboss.weld.metadata.cache.ScopeModel;
import org.jboss.weld.metadata.cache.StereotypeModel;
import org.jboss.weld.module.EjbSupport;
import org.jboss.weld.module.ExpressionLanguageSupport;
import org.jboss.weld.module.ObserverNotifierFactory;
import org.jboss.weld.resolution.BeanTypeAssignabilityRules;
import org.jboss.weld.resolution.DecoratorResolvableBuilder;
import org.jboss.weld.resolution.InterceptorResolvable;
import org.jboss.weld.resolution.InterceptorResolvableBuilder;
import org.jboss.weld.resolution.NameBasedResolver;
import org.jboss.weld.resolution.QualifierInstance;
import org.jboss.weld.resolution.Resolvable;
import org.jboss.weld.resolution.ResolvableBuilder;
import org.jboss.weld.resolution.TypeSafeBeanResolver;
import org.jboss.weld.resolution.TypeSafeDecoratorResolver;
import org.jboss.weld.resolution.TypeSafeInterceptorResolver;
import org.jboss.weld.resolution.TypeSafeObserverResolver;
import org.jboss.weld.resources.ClassTransformer;
import org.jboss.weld.resources.MemberTransformer;
import org.jboss.weld.serialization.ContextualStoreImpl;
import org.jboss.weld.serialization.spi.BeanIdentifier;
import org.jboss.weld.serialization.spi.ContextualStore;
import org.jboss.weld.util.Beans;
import org.jboss.weld.util.Bindings;
import org.jboss.weld.util.ForwardingBeanManager;
import org.jboss.weld.util.InjectionPoints;
import org.jboss.weld.util.Interceptors;
import org.jboss.weld.util.LazyValueHolder;
import org.jboss.weld.util.Observers;
import org.jboss.weld.util.Preconditions;
import org.jboss.weld.util.Types;
import org.jboss.weld.util.collections.ImmutableSet;
import org.jboss.weld.util.collections.Iterables;
import org.jboss.weld.util.collections.SetMultimap;
import org.jboss.weld.util.collections.WeldCollections;
import org.jboss.weld.util.reflection.Reflections;

public class BeanManagerImpl
implements WeldManager,
Serializable {
    private static final long serialVersionUID = 3021562879133838561L;
    private static final String CREATIONAL_CONTEXT = "creationalContext";
    private final transient ServiceRegistry services;
    private final transient Map<Class<? extends Annotation>, List<Context>> contexts;
    private final transient ClientProxyProvider clientProxyProvider;
    private final transient Map<EjbDescriptor<?>, SessionBean<?>> enterpriseBeans;
    private volatile transient ModuleEnablement enabled;
    private final transient TypeSafeBeanResolver beanResolver;
    private final transient TypeSafeDecoratorResolver decoratorResolver;
    private final transient TypeSafeInterceptorResolver interceptorResolver;
    private final transient NameBasedResolver nameBasedResolver;
    private final transient ELResolver weldELResolver;
    private final transient ObserverNotifier accessibleLenientObserverNotifier;
    private final transient ObserverNotifier globalLenientObserverNotifier;
    private final transient ObserverNotifier globalStrictObserverNotifier;
    private final transient List<Bean<?>> enabledBeans;
    private final transient List<Bean<?>> sharedBeans;
    private final transient List<Bean<?>> specializedBeans;
    private final transient List<Decorator<?>> decorators;
    private final transient List<Interceptor<?>> interceptors;
    private final transient List<String> namespaces;
    private final transient List<ObserverMethod<?>> observers;
    private transient Set<Bean<?>> beanSet = Collections.synchronizedSet(new HashSet());
    private final transient Set<BeanManagerImpl> managers;
    private final transient HashSet<BeanManagerImpl> accessibleManagers;
    private final String id;
    private final String contextId;
    private final transient ConcurrentMap<SlimAnnotatedType<?>, InterceptionModel> interceptorModelRegistry = new ConcurrentHashMap();
    private final transient InterceptorMetadataReader interceptorMetadataReader = new InterceptorMetadataReader(this);
    private final transient ContainerLifecycleEvents containerLifecycleEvents;
    private final transient SpecializationAndEnablementRegistry registry;
    private final transient CurrentInjectionPoint currentInjectionPoint;
    private final transient boolean clientProxyOptimization;
    private final transient List<BiConsumer<Exception, Environment>> validationFailureCallbacks;
    private final transient LazyValueHolder<FastEvent<Object>> requestInitializedEvent;
    private final transient LazyValueHolder<FastEvent<Object>> requestBeforeDestroyedEvent;
    private final transient LazyValueHolder<FastEvent<Object>> requestDestroyedEvent;

    public static BeanManagerImpl newRootManager(String contextId, String id, ServiceRegistry serviceRegistry) {
        ConcurrentHashMap<Class<? extends Annotation>, List<Context>> contexts = new ConcurrentHashMap<Class<? extends Annotation>, List<Context>>();
        return new BeanManagerImpl(serviceRegistry, new CopyOnWriteArrayList(), new CopyOnWriteArrayList(), new CopyOnWriteArrayList(), new CopyOnWriteArrayList(), new CopyOnWriteArrayList(), new CopyOnWriteArrayList<String>(), new ConcurrentHashMap(), new ClientProxyProvider(contextId), contexts, ModuleEnablement.EMPTY_ENABLEMENT, id, new AtomicInteger(), new HashSet<BeanManagerImpl>(), contextId);
    }

    public static BeanManagerImpl newManager(BeanManagerImpl rootManager, String id, ServiceRegistry services) {
        return new BeanManagerImpl(services, new CopyOnWriteArrayList(), new CopyOnWriteArrayList(), new CopyOnWriteArrayList(), new CopyOnWriteArrayList(), new CopyOnWriteArrayList(), new CopyOnWriteArrayList<String>(), rootManager.getEnterpriseBeans(), rootManager.getClientProxyProvider(), rootManager.getContexts(), ModuleEnablement.EMPTY_ENABLEMENT, id, new AtomicInteger(), rootManager.managers, rootManager.contextId);
    }

    private BeanManagerImpl(ServiceRegistry serviceRegistry, List<Bean<?>> beans, List<Bean<?>> transitiveBeans, List<Decorator<?>> decorators, List<Interceptor<?>> interceptors, List<ObserverMethod<?>> observers, List<String> namespaces, Map<EjbDescriptor<?>, SessionBean<?>> enterpriseBeans, ClientProxyProvider clientProxyProvider, Map<Class<? extends Annotation>, List<Context>> contexts, ModuleEnablement enabled, String id, AtomicInteger childIds, Set<BeanManagerImpl> managers, String contextId) {
        this.services = serviceRegistry;
        this.enabledBeans = beans;
        this.sharedBeans = transitiveBeans;
        this.decorators = decorators;
        this.interceptors = interceptors;
        this.enterpriseBeans = enterpriseBeans;
        this.clientProxyProvider = clientProxyProvider;
        this.contexts = contexts;
        this.observers = observers;
        this.enabled = enabled;
        this.namespaces = namespaces;
        this.id = id;
        this.managers = managers;
        this.contextId = contextId;
        managers.add(this);
        this.accessibleManagers = new HashSet();
        BeanTransform beanTransform = new BeanTransform(this);
        this.beanResolver = new TypeSafeBeanResolver(this, this.createDynamicAccessibleIterable(beanTransform));
        this.decoratorResolver = new TypeSafeDecoratorResolver(this, this.createDynamicGlobalIterable(BeanManagerImpl::getDecorators));
        this.interceptorResolver = new TypeSafeInterceptorResolver(this, this.createDynamicGlobalIterable(BeanManagerImpl::getInterceptors));
        this.nameBasedResolver = new NameBasedResolver(this, this.createDynamicAccessibleIterable(beanTransform));
        this.weldELResolver = this.services.getOptional(ExpressionLanguageSupport.class).map(el -> el.createElResolver(this)).orElse(null);
        TypeSafeObserverResolver accessibleObserverResolver = new TypeSafeObserverResolver(this.getServices().get(MetaAnnotationStore.class), this.createDynamicAccessibleIterable(BeanManagerImpl::getObservers), this.getServices().get(WeldConfiguration.class));
        this.accessibleLenientObserverNotifier = this.getServices().get(ObserverNotifierFactory.class).create(contextId, accessibleObserverResolver, this.getServices(), false);
        GlobalObserverNotifierService globalObserverNotifierService = this.services.get(GlobalObserverNotifierService.class);
        this.globalLenientObserverNotifier = globalObserverNotifierService.getGlobalLenientObserverNotifier();
        this.globalStrictObserverNotifier = globalObserverNotifierService.getGlobalStrictObserverNotifier();
        globalObserverNotifierService.registerBeanManager(this);
        this.containerLifecycleEvents = serviceRegistry.get(ContainerLifecycleEvents.class);
        this.registry = this.getServices().get(SpecializationAndEnablementRegistry.class);
        this.currentInjectionPoint = this.getServices().get(CurrentInjectionPoint.class);
        this.clientProxyOptimization = this.getServices().get(WeldConfiguration.class).getBooleanProperty(ConfigurationKey.INJECTABLE_REFERENCE_OPTIMIZATION);
        this.requestInitializedEvent = LazyValueHolder.forSupplier(() -> FastEvent.of(Object.class, this, new Annotation[]{Initialized.Literal.REQUEST}));
        this.requestBeforeDestroyedEvent = LazyValueHolder.forSupplier(() -> FastEvent.of(Object.class, this, new Annotation[]{BeforeDestroyed.Literal.REQUEST}));
        this.requestDestroyedEvent = LazyValueHolder.forSupplier(() -> FastEvent.of(Object.class, this, new Annotation[]{Destroyed.Literal.REQUEST}));
        this.validationFailureCallbacks = new CopyOnWriteArrayList<BiConsumer<Exception, Environment>>();
        this.specializedBeans = new CopyOnWriteArrayList();
    }

    private <T> Iterable<T> createDynamicGlobalIterable(Function<BeanManagerImpl, Iterable<T>> transform) {
        return Iterables.flatMap(this.managers, transform);
    }

    public String getContextId() {
        return this.contextId;
    }

    private <T> Iterable<T> createDynamicAccessibleIterable(Function<BeanManagerImpl, Iterable<T>> transform) {
        return Iterables.concat(Iterables.flatMap(this.getAccessibleManagers(), transform), transform.apply(this));
    }

    public void addAccessibleBeanManager(BeanManagerImpl accessibleBeanManager) {
        this.accessibleManagers.add(accessibleBeanManager);
        this.beanResolver.clear();
        this.interceptorResolver.clear();
        this.decoratorResolver.clear();
        this.accessibleLenientObserverNotifier.clear();
    }

    public HashSet<BeanManagerImpl> getAccessibleManagers() {
        return this.accessibleManagers;
    }

    public void addBean(Bean<?> bean) {
        this.addBean(bean, this.enabledBeans, this.sharedBeans);
    }

    public void addBeans(Collection<? extends Bean<?>> beans) {
        ArrayList beanList = new ArrayList(beans.size());
        ArrayList transitiveBeans = new ArrayList(beans.size());
        for (Bean<?> bean : beans) {
            this.addBean(bean, beanList, transitiveBeans);
        }
        this.enabledBeans.addAll(beanList);
        this.sharedBeans.addAll(transitiveBeans);
    }

    private boolean isConfiguratorBeanWithPriority(Bean<?> bean) {
        return bean instanceof WeldBean && ((WeldBean)bean).getPriority() != null;
    }

    private void addBean(Bean<?> bean, List<Bean<?>> beanList, List<Bean<?>> transitiveBeans) {
        if (this.beanSet.add(bean)) {
            if (bean.isAlternative() && !this.registry.isEnabledInAnyBeanDeployment(bean) && !(bean instanceof Prioritized) && !this.isConfiguratorBeanWithPriority(bean)) {
                BootstrapLogger.LOG.foundDisabledAlternative(bean);
            } else if (this.registry.isSpecializedInAnyBeanDeployment(bean)) {
                BootstrapLogger.LOG.foundSpecializedBean(bean);
            } else if (bean instanceof AbstractProducerBean && this.registry.isSpecializedInAnyBeanDeployment(((AbstractProducerBean)bean).getDeclaringBean())) {
                BootstrapLogger.LOG.foundProducerOfSpecializedBean(bean);
                this.specializedBeans.add(bean);
            } else {
                BootstrapLogger.LOG.foundBean(bean);
                beanList.add(bean);
                if (bean instanceof SessionBean) {
                    SessionBean enterpriseBean = (SessionBean)bean;
                    this.enterpriseBeans.put(enterpriseBean.getEjbDescriptor(), enterpriseBean);
                }
                if (bean instanceof PassivationCapable) {
                    this.getServices().get(ContextualStore.class).putIfAbsent((Contextual<?>)bean);
                }
                this.registerBeanNamespace(bean);
                if (bean instanceof ExtensionBean || bean instanceof SessionBean || !(bean instanceof NewBean) && !(bean instanceof AbstractBuiltInBean)) {
                    transitiveBeans.add(bean);
                }
            }
        }
    }

    public void addDecorator(Decorator<?> bean) {
        this.decorators.add(bean);
        this.getServices().get(ContextualStore.class).putIfAbsent((Contextual<?>)bean);
        this.decoratorResolver.clear();
    }

    public <T> Set<ObserverMethod<? super T>> resolveObserverMethods(T event, Annotation ... bindings) {
        return ImmutableSet.copyOf(this.globalStrictObserverNotifier.resolveObserverMethods(event.getClass(), bindings).getAllObservers());
    }

    public void addInterceptor(Interceptor<?> bean) {
        this.interceptors.add(bean);
        this.getServices().get(ContextualStore.class).putIfAbsent((Contextual<?>)bean);
        this.interceptorResolver.clear();
    }

    public ModuleEnablement getEnabled() {
        return this.enabled;
    }

    public void setEnabled(ModuleEnablement enabled) {
        this.enabled = enabled;
    }

    public boolean isBeanEnabled(Bean<?> bean) {
        return Beans.isBeanEnabled(bean, this.getEnabled());
    }

    public Set<Bean<?>> getBeans(Type beanType, Annotation ... qualifiers) {
        Resolvable resolvable = new ResolvableBuilder(beanType, this).addQualifiers(qualifiers).create();
        return (Set)this.beanResolver.resolve(resolvable, Reflections.isCacheable(qualifiers));
    }

    public Set<Bean<?>> getBeans(Type beanType, Set<Annotation> qualifiers) {
        return (Set)this.beanResolver.resolve(new ResolvableBuilder(beanType, this).addQualifiers(qualifiers).create(), Reflections.isCacheable(qualifiers));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<Bean<?>> getBeans(InjectionPoint injectionPoint) {
        boolean registerInjectionPoint = this.isRegisterableInjectionPoint(injectionPoint);
        ThreadLocalStack.ThreadLocalStackReference<InjectionPoint> stack = this.currentInjectionPoint.pushConditionally(injectionPoint, registerInjectionPoint);
        try {
            Set set = (Set)this.beanResolver.resolve(new ResolvableBuilder(injectionPoint, this).create(), true);
            return set;
        }
        finally {
            stack.pop();
        }
    }

    protected void registerBeanNamespace(Bean<?> bean) {
        String[] parts;
        if (bean.getName() != null && (parts = bean.getName().split("\\.")).length > 1) {
            for (int i = 0; i < parts.length - 1; ++i) {
                StringBuilder builder = new StringBuilder();
                for (int j = 0; j <= i; ++j) {
                    if (j > 0) {
                        builder.append('.');
                    }
                    builder.append(parts[j]);
                }
                this.namespaces.add(builder.toString());
            }
        }
    }

    public Map<EjbDescriptor<?>, SessionBean<?>> getEnterpriseBeans() {
        return this.enterpriseBeans;
    }

    public List<Bean<?>> getBeans() {
        return WeldCollections.immutableListView(this.enabledBeans);
    }

    List<Bean<?>> getSharedBeans() {
        return WeldCollections.immutableListView(this.sharedBeans);
    }

    public List<Decorator<?>> getDecorators() {
        return WeldCollections.immutableListView(this.decorators);
    }

    public List<Interceptor<?>> getInterceptors() {
        return WeldCollections.immutableListView(this.interceptors);
    }

    public Iterable<Bean<?>> getDynamicAccessibleBeans() {
        return this.createDynamicAccessibleIterable(new BeanTransform(this));
    }

    public Set<Bean<?>> getAccessibleBeans() {
        HashSet beans = new HashSet();
        beans.addAll(this.getBeans());
        for (BeanManagerImpl beanManager : this.getAccessibleManagers()) {
            beans.addAll(beanManager.getSharedBeans());
        }
        return beans;
    }

    public Iterable<Interceptor<?>> getDynamicAccessibleInterceptors() {
        return this.createDynamicAccessibleIterable(BeanManagerImpl::getInterceptors);
    }

    public Iterable<Decorator<?>> getDynamicAccessibleDecorators() {
        return this.createDynamicAccessibleIterable(BeanManagerImpl::getDecorators);
    }

    public void addContext(Context context) {
        List<Context> contextList;
        Class scope = context.getScope();
        if (this.isPassivatingScope(scope)) {
            context = PassivatingContextWrapper.wrap(context, this.services.get(ContextualStore.class));
        }
        if ((contextList = this.contexts.get(scope)) == null) {
            contextList = new CopyOnWriteArrayList<Context>();
            this.contexts.put(scope, contextList);
        }
        contextList.add(context);
    }

    public void addObserver(ObserverMethod<?> observer) {
        this.observers.add(observer);
    }

    public void fireEvent(Object event, Annotation ... qualifiers) {
        Preconditions.checkArgumentNotNull(event, "event");
        Type eventType = Types.getCanonicalType(event.getClass());
        EventMetadataImpl metadata = new EventMetadataImpl(eventType, null, qualifiers);
        this.globalStrictObserverNotifier.fireEvent(event, metadata, qualifiers);
    }

    public Context getContext(Class<? extends Annotation> scopeType) {
        Context activeContext = this.internalGetContext(scopeType);
        if (activeContext == null) {
            throw BeanManagerLogger.LOG.contextNotActive(scopeType.getName());
        }
        return activeContext;
    }

    public Context getUnwrappedContext(Class<? extends Annotation> scopeType) {
        return PassivatingContextWrapper.unwrap(this.getContext(scopeType));
    }

    @Override
    public boolean isContextActive(Class<? extends Annotation> scopeType) {
        return this.internalGetContext(scopeType) != null;
    }

    private Context internalGetContext(Class<? extends Annotation> scopeType) {
        Context activeContext = null;
        List<Context> ctx = this.contexts.get(scopeType);
        if (ctx == null) {
            return null;
        }
        for (Context context : ctx) {
            if (!context.isActive()) continue;
            if (activeContext == null) {
                activeContext = context;
                continue;
            }
            throw BeanManagerLogger.LOG.duplicateActiveContexts(scopeType.getName());
        }
        return activeContext;
    }

    public Object getReference(Bean<?> bean, Type requestedType, CreationalContext<?> creationalContext, boolean noProxy) {
        if (creationalContext instanceof CreationalContextImpl) {
            creationalContext = ((CreationalContextImpl)creationalContext).getCreationalContext((Contextual)bean);
        }
        if (!noProxy && this.isProxyRequired(bean)) {
            if (creationalContext != null || ContextualInstance.getIfExists(bean, this) != null) {
                if (requestedType == null) {
                    return this.clientProxyProvider.getClientProxy(bean);
                }
                return this.clientProxyProvider.getClientProxy(bean, requestedType);
            }
            return null;
        }
        return ContextualInstance.get(bean, this, creationalContext);
    }

    private boolean isProxyRequired(Bean<?> bean) {
        if (bean instanceof RIBean) {
            return ((RIBean)bean).isProxyRequired();
        }
        return this.isNormalScope(bean.getScope());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getReference(Bean<?> bean, Type requestedType, CreationalContext<?> creationalContext) {
        Preconditions.checkArgumentNotNull(bean, "bean");
        Preconditions.checkArgumentNotNull(requestedType, "requestedType");
        Preconditions.checkArgumentNotNull(creationalContext, CREATIONAL_CONTEXT);
        if (!BeanTypeAssignabilityRules.instance().matches(requestedType, bean.getTypes())) {
            throw BeanManagerLogger.LOG.specifiedTypeNotBeanType(requestedType, bean);
        }
        ThreadLocalStack.ThreadLocalStackReference<InjectionPoint> stack = this.currentInjectionPoint.push(EmptyInjectionPoint.INSTANCE);
        try {
            Object object = this.getReference(bean, requestedType, creationalContext, false);
            return object;
        }
        finally {
            stack.pop();
        }
    }

    @Deprecated
    public Object getReference(InjectionPoint injectionPoint, Bean<?> resolvedBean, CreationalContext<?> creationalContext) {
        return this.getInjectableReference(injectionPoint, resolvedBean, creationalContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getInjectableReference(InjectionPoint injectionPoint, Bean<?> resolvedBean, CreationalContext<?> creationalContext) {
        Preconditions.checkArgumentNotNull(resolvedBean, "resolvedBean");
        Preconditions.checkArgumentNotNull(creationalContext, CREATIONAL_CONTEXT);
        boolean registerInjectionPoint = this.isRegisterableInjectionPoint(injectionPoint);
        boolean delegateInjectionPoint = injectionPoint != null && injectionPoint.isDelegate();
        ThreadLocalStack.ThreadLocalStackReference<InjectionPoint> stack = this.currentInjectionPoint.pushConditionally(injectionPoint, registerInjectionPoint);
        try {
            Type requestedType = null;
            if (injectionPoint != null) {
                requestedType = injectionPoint.getType();
            }
            if (this.clientProxyOptimization && injectionPoint != null && injectionPoint.getBean() != null) {
                CreationalContextImpl weldCreationalContext = null;
                Bean<?> bean = injectionPoint.getBean();
                if (!bean.equals(resolvedBean)) {
                    if (creationalContext instanceof CreationalContextImpl) {
                        weldCreationalContext = (CreationalContextImpl)creationalContext;
                    }
                    if (weldCreationalContext != null && Dependent.class.equals((Object)bean.getScope()) && this.isNormalScope(resolvedBean.getScope())) {
                        bean = this.findNormalScopedDependant(weldCreationalContext);
                    }
                    if (InjectionPoints.isInjectableReferenceLookupOptimizationAllowed(bean, resolvedBean)) {
                        Object existinInstance;
                        Object incompleteInstance;
                        if (weldCreationalContext != null && (incompleteInstance = weldCreationalContext.getIncompleteInstance(resolvedBean)) != null) {
                            Object obj = incompleteInstance;
                            return obj;
                        }
                        Context context = this.internalGetContext(resolvedBean.getScope());
                        if (context != null && (existinInstance = context.get((Contextual)Reflections.cast(resolvedBean))) != null) {
                            Object object = existinInstance;
                            return object;
                        }
                    }
                }
            }
            Object object = this.getReference(resolvedBean, requestedType, creationalContext, delegateInjectionPoint);
            return object;
        }
        finally {
            stack.pop();
        }
    }

    public Object getInjectableReference(InjectionPoint injectionPoint, CreationalContext<?> creationalContext) {
        if (injectionPoint.isDelegate()) {
            return DecorationHelper.peek().getNextDelegate(injectionPoint, creationalContext);
        }
        Bean resolvedBean = this.getBean(new ResolvableBuilder(injectionPoint, this).create());
        return this.getInjectableReference(injectionPoint, resolvedBean, creationalContext);
    }

    public <T> Bean<T> getBean(Resolvable resolvable) {
        Bean bean = (Bean)Reflections.cast(this.resolve((Set)this.beanResolver.resolve(resolvable, true)));
        if (bean == null) {
            throw BeanManagerLogger.LOG.unresolvableElement(resolvable);
        }
        return bean;
    }

    public Set<Bean<?>> getBeans(String name) {
        return this.nameBasedResolver.resolve(name);
    }

    public List<Decorator<?>> resolveDecorators(Set<Type> types, Annotation ... qualifiers) {
        this.checkResolveDecoratorsArguments(types);
        return (List)this.decoratorResolver.resolve(new DecoratorResolvableBuilder(this).addTypes(types).addQualifiers(qualifiers).create(), Reflections.isCacheable(qualifiers));
    }

    public List<Decorator<?>> resolveDecorators(Set<Type> types, Set<Annotation> qualifiers) {
        this.checkResolveDecoratorsArguments(types);
        return (List)this.decoratorResolver.resolve(new DecoratorResolvableBuilder(this).addTypes(types).addQualifiers(qualifiers).create(), true);
    }

    private void checkResolveDecoratorsArguments(Set<Type> types) {
        if (types.isEmpty()) {
            throw BeanManagerLogger.LOG.noDecoratorTypes();
        }
    }

    public List<Interceptor<?>> resolveInterceptors(InterceptionType type, Annotation ... interceptorBindings) {
        if (interceptorBindings.length == 0) {
            throw BeanManagerLogger.LOG.interceptorBindingsEmpty();
        }
        for (Annotation annotation : interceptorBindings) {
            if (this.isInterceptorBinding(annotation.annotationType())) continue;
            throw BeanManagerLogger.LOG.notInterceptorBindingType(annotation);
        }
        Set<Annotation> flattenedInterceptorBindings = Interceptors.flattenInterceptorBindings(null, this, Arrays.asList(interceptorBindings), true, true);
        return this.resolveInterceptors(type, flattenedInterceptorBindings);
    }

    public List<Interceptor<?>> resolveInterceptors(InterceptionType type, Collection<Annotation> interceptorBindings) {
        InterceptorResolvable interceptorResolvable = ((InterceptorResolvableBuilder)new InterceptorResolvableBuilder((Type)((Object)Object.class), this).setInterceptionType(type).addQualifiers((Collection)interceptorBindings)).create();
        return (List)this.interceptorResolver.resolve(interceptorResolvable, Reflections.isCacheable(interceptorBindings));
    }

    public TypeSafeBeanResolver getBeanResolver() {
        return this.beanResolver;
    }

    public TypeSafeDecoratorResolver getDecoratorResolver() {
        return this.decoratorResolver;
    }

    public TypeSafeInterceptorResolver getInterceptorResolver() {
        return this.interceptorResolver;
    }

    public NameBasedResolver getNameBasedResolver() {
        return this.nameBasedResolver;
    }

    public ObserverNotifier getAccessibleLenientObserverNotifier() {
        return this.accessibleLenientObserverNotifier;
    }

    public ObserverNotifier getGlobalLenientObserverNotifier() {
        return this.globalLenientObserverNotifier;
    }

    public ObserverNotifier getGlobalStrictObserverNotifier() {
        return this.globalStrictObserverNotifier;
    }

    public String toString() {
        return "Weld BeanManager for " + this.getId() + " [bean count=" + this.getBeans().size() + "]";
    }

    @SuppressFBWarnings(value={"EQ_CHECK_FOR_OPERAND_NOT_COMPATIBLE_WITH_THIS"})
    public boolean equals(Object obj) {
        if (obj instanceof ForwardingBeanManager) {
            ForwardingBeanManager proxy = (ForwardingBeanManager)obj;
            obj = proxy.delegate();
        }
        if (obj instanceof BeanManagerImpl) {
            BeanManagerImpl that = (BeanManagerImpl)obj;
            return this.getId().equals(that.getId());
        }
        return false;
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    @Override
    public ServiceRegistry getServices() {
        return this.services;
    }

    protected Object readResolve() throws ObjectStreamException {
        return Container.instance(this.contextId).getBeanManager(this.id);
    }

    public ClientProxyProvider getClientProxyProvider() {
        return this.clientProxyProvider;
    }

    protected Map<Class<? extends Annotation>, List<Context>> getContexts() {
        return this.contexts;
    }

    protected List<String> getNamespaces() {
        return this.namespaces;
    }

    public Iterable<String> getDynamicAccessibleNamespaces() {
        return this.createDynamicAccessibleIterable(BeanManagerImpl::getNamespaces);
    }

    public List<String> getAccessibleNamespaces() {
        ArrayList<String> namespaces = new ArrayList<String>();
        namespaces.addAll(this.getNamespaces());
        for (BeanManagerImpl beanManagerImpl : this.getAccessibleManagers()) {
            namespaces.addAll(beanManagerImpl.getNamespaces());
        }
        return namespaces;
    }

    @Override
    public String getId() {
        return this.id;
    }

    public List<ObserverMethod<?>> getObservers() {
        return this.observers;
    }

    public <T> InjectionTarget<T> createInjectionTarget(AnnotatedType<T> type) {
        return this.getInjectionTargetFactory((AnnotatedType)type).createInjectionTarget((Bean)null);
    }

    @Override
    public <T> InjectionTarget<T> createInjectionTarget(EjbDescriptor<T> descriptor) {
        if (descriptor.isMessageDriven()) {
            AnnotatedType type = (AnnotatedType)Reflections.cast(this.createAnnotatedType(descriptor.getBeanClass()));
            return this.getLocalInjectionTargetFactory(type).createMessageDrivenInjectionTarget(descriptor);
        }
        InjectionTarget injectionTarget = this.getBean((EjbDescriptor)descriptor).getProducer();
        return injectionTarget;
    }

    public void validate(InjectionPoint ij) {
        try {
            this.getServices().get(Validator.class).validateInjectionPoint(ij, this);
        }
        catch (DeploymentException e) {
            throw new InjectionException(e.getLocalizedMessage(), e.getCause());
        }
    }

    public Set<Annotation> getInterceptorBindingDefinition(Class<? extends Annotation> bindingType) {
        InterceptorBindingModel<? extends Annotation> model = this.getServices().get(MetaAnnotationStore.class).getInterceptorBindingModel(bindingType);
        if (model.isValid()) {
            return model.getMetaAnnotations();
        }
        throw BeanManagerLogger.LOG.notInterceptorBindingType(bindingType);
    }

    public Bean<?> getPassivationCapableBean(String id) {
        return (Bean)this.getServices().get(ContextualStore.class).getContextual(id);
    }

    @Override
    public Bean<?> getPassivationCapableBean(BeanIdentifier identifier) {
        return (Bean)this.getServices().get(ContextualStore.class).getContextual(identifier);
    }

    public Set<Annotation> getStereotypeDefinition(Class<? extends Annotation> stereotype) {
        StereotypeModel<? extends Annotation> model = this.getServices().get(MetaAnnotationStore.class).getStereotype(stereotype);
        if (model.isValid()) {
            return model.getMetaAnnotations();
        }
        throw BeanManagerLogger.LOG.notStereotype(stereotype);
    }

    public boolean isQualifier(Class<? extends Annotation> annotationType) {
        return this.getServices().get(MetaAnnotationStore.class).getBindingTypeModel(annotationType).isValid();
    }

    public boolean isInterceptorBinding(Class<? extends Annotation> annotationType) {
        return this.getServices().get(MetaAnnotationStore.class).getInterceptorBindingModel(annotationType).isValid();
    }

    public boolean isNormalScope(Class<? extends Annotation> annotationType) {
        ScopeModel<? extends Annotation> scope = this.getServices().get(MetaAnnotationStore.class).getScopeModel(annotationType);
        return scope.isValid() && scope.isNormal();
    }

    public boolean isPassivatingScope(Class<? extends Annotation> annotationType) {
        ScopeModel<? extends Annotation> scope = this.getServices().get(MetaAnnotationStore.class).getScopeModel(annotationType);
        return scope.isValid() && scope.isPassivating();
    }

    public boolean isScope(Class<? extends Annotation> annotationType) {
        return this.getServices().get(MetaAnnotationStore.class).getScopeModel(annotationType).isValid();
    }

    public boolean isStereotype(Class<? extends Annotation> annotationType) {
        return this.getServices().get(MetaAnnotationStore.class).getStereotype(annotationType).isValid();
    }

    public ELResolver getELResolver() {
        if (this.weldELResolver == null) {
            throw BootstrapLogger.LOG.unspecifiedRequiredService(ExpressionLanguageSupport.class, this.id);
        }
        return this.weldELResolver;
    }

    public ExpressionFactory wrapExpressionFactory(ExpressionFactory expressionFactory) {
        return this.services.getOptional(ExpressionLanguageSupport.class).orElseThrow(() -> BootstrapLogger.LOG.unspecifiedRequiredService(ExpressionLanguageSupport.class, this.id)).wrapExpressionFactory(expressionFactory);
    }

    public <T> WeldCreationalContext<T> createCreationalContext(Contextual<T> contextual) {
        return new CreationalContextImpl<T>(contextual);
    }

    public <T> AnnotatedType<T> createAnnotatedType(Class<T> type) {
        String bdaId = BeanManagerLookupService.lookupBeanManager(type, this).getId();
        return this.getServices().get(ClassTransformer.class).getBackedAnnotatedType(type, bdaId);
    }

    public <T> EnhancedAnnotatedType<T> createEnhancedAnnotatedType(Class<T> type) {
        String bdaId = BeanManagerLookupService.lookupBeanManager(type, this).getId();
        return this.getServices().get(ClassTransformer.class).getEnhancedAnnotatedType(type, bdaId);
    }

    @Override
    public <T> AnnotatedType<T> createAnnotatedType(Class<T> type, String id) {
        return this.getServices().get(ClassTransformer.class).getBackedAnnotatedType(type, BeanManagerLookupService.lookupBeanManager(type, this).getId(), id);
    }

    @Override
    public <T> void disposeAnnotatedType(Class<T> type, String id) {
        this.getServices().get(ClassTransformer.class).disposeBackedAnnotatedType(type, BeanManagerLookupService.lookupBeanManager(type, this).getId(), id);
    }

    public <X> Bean<? extends X> resolve(Set<Bean<? extends X>> beans) {
        if (beans == null || beans.isEmpty()) {
            return null;
        }
        Set<Bean<X>> resolvedBeans = this.beanResolver.resolve(beans);
        if (resolvedBeans.size() == 1) {
            return resolvedBeans.iterator().next();
        }
        if (resolvedBeans.size() == 0) {
            return null;
        }
        throw BeanManagerLogger.LOG.ambiguousBeansForDependency(WeldCollections.toMultiRowString(beans));
    }

    @Override
    public <T> EjbDescriptor<T> getEjbDescriptor(String beanName) {
        return this.getServices().get(EjbSupport.class).getEjbDescriptor(beanName);
    }

    public <T> SessionBean<T> getBean(EjbDescriptor<T> descriptor) {
        return (SessionBean)Reflections.cast(this.getEnterpriseBeans().get(descriptor));
    }

    public void cleanup() {
        this.services.cleanup();
        this.accessibleManagers.clear();
        this.managers.clear();
        this.beanResolver.clear();
        this.enabledBeans.clear();
        this.clientProxyProvider.clear();
        this.contexts.clear();
        this.decoratorResolver.clear();
        this.decorators.clear();
        this.enterpriseBeans.clear();
        this.interceptorResolver.clear();
        this.interceptors.clear();
        this.nameBasedResolver.clear();
        this.namespaces.clear();
        this.accessibleLenientObserverNotifier.clear();
        this.observers.clear();
    }

    public void cleanupAfterBoot() {
        if (this.beanSet != null) {
            this.beanSet.clear();
            this.beanSet = null;
        }
        this.validationFailureCallbacks.clear();
        boolean isOptimizedCleanupAllowed = this.getServices().get(WeldConfiguration.class).getBooleanProperty(ConfigurationKey.ALLOW_OPTIMIZED_CLEANUP);
        if (!this.observers.isEmpty()) {
            this.observers.removeIf(o -> o instanceof ContainerLifecycleEventObserverMethod && Observers.CONTAINER_LIFECYCLE_EVENT_TYPES.contains(Reflections.getRawType(o.getObservedType())) && !BeforeShutdown.class.equals(Reflections.getRawType(o.getObservedType())) && (isOptimizedCleanupAllowed || !ProcessInjectionPoint.class.equals(Reflections.getRawType(o.getObservedType())) && !ProcessInjectionTarget.class.equals(Reflections.getRawType(o.getObservedType()))));
        }
        if (isOptimizedCleanupAllowed) {
            this.removeUnusedBeans();
            if (!this.specializedBeans.isEmpty()) {
                ((ContextualStoreImpl)this.getServices().get(ContextualStore.class)).removeAll(this.specializedBeans);
                this.cleanupBeansAfterBoot(this.specializedBeans);
                this.specializedBeans.clear();
            }
        }
    }

    public ConcurrentMap<SlimAnnotatedType<?>, InterceptionModel> getInterceptorModelRegistry() {
        return this.interceptorModelRegistry;
    }

    public InterceptorMetadataReader getInterceptorMetadataReader() {
        return this.interceptorMetadataReader;
    }

    @Override
    public <X> InjectionTarget<X> fireProcessInjectionTarget(AnnotatedType<X> annotatedType) {
        return this.fireProcessInjectionTarget(annotatedType, this.createInjectionTarget(annotatedType));
    }

    @Override
    public <X> InjectionTarget<X> fireProcessInjectionTarget(AnnotatedType<X> annotatedType, InjectionTarget<X> injectionTarget) {
        return this.services.get(ContainerLifecycleEvents.class).fireProcessInjectionTarget(this, annotatedType, injectionTarget);
    }

    public Set<QualifierInstance> extractInterceptorBindingsForQualifierInstance(Iterable<QualifierInstance> annotations) {
        HashSet<QualifierInstance> foundInterceptionBindingTypes = new HashSet<QualifierInstance>();
        for (QualifierInstance annotation : annotations) {
            if (!this.isInterceptorBinding(annotation.getAnnotationClass())) continue;
            foundInterceptionBindingTypes.add(annotation);
        }
        return foundInterceptionBindingTypes;
    }

    @Override
    public Instance<Object> instance() {
        return this.getInstance(this.createCreationalContext((Contextual)null));
    }

    public WeldEvent<Object> event() {
        return EventImpl.of(EventInjectionPoint.INSTANCE, this);
    }

    public <T> WeldInstance<Object> getInstance(CreationalContext<?> ctx) {
        return (WeldInstance)Reflections.cast(InstanceImpl.of(InstanceInjectionPoint.INSTANCE, ctx, this));
    }

    public <T> BeanAttributes<T> createBeanAttributes(AnnotatedType<T> type) {
        EnhancedAnnotatedType<T> clazz = this.services.get(ClassTransformer.class).getEnhancedAnnotatedType(type, this.getId());
        if (this.services.get(EjbSupport.class).isEjb(type.getJavaClass())) {
            return this.services.get(EjbSupport.class).createSessionBeanAttributes(clazz, this);
        }
        return BeanAttributesFactory.forBean(clazz, this);
    }

    public BeanAttributes<?> createBeanAttributes(AnnotatedMember<?> member) {
        return this.internalCreateBeanAttributes(member);
    }

    public <X> BeanAttributes<?> internalCreateBeanAttributes(AnnotatedMember<X> member) {
        EnhancedAnnotated weldMember = null;
        if (!(member instanceof AnnotatedField) && !(member instanceof AnnotatedMethod)) {
            throw BeanManagerLogger.LOG.cannotCreateBeanAttributesForIncorrectAnnotatedMember(member);
        }
        weldMember = (EnhancedAnnotated)this.services.get(MemberTransformer.class).loadEnhancedMember(member, this.getId());
        return BeanAttributesFactory.forBean(weldMember, this);
    }

    public <T> Bean<T> createBean(BeanAttributes<T> attributes, Class<T> beanClass, InjectionTargetFactory<T> injectionTargetFactory) {
        return SyntheticBeanFactory.create(attributes, beanClass, injectionTargetFactory, this);
    }

    public <T, X> Bean<T> createBean(BeanAttributes<T> attributes, Class<X> beanClass, ProducerFactory<X> producerFactory) {
        return SyntheticBeanFactory.create(attributes, beanClass, producerFactory, this);
    }

    public FieldInjectionPointAttributes<?, ?> createInjectionPoint(AnnotatedField<?> field) {
        AnnotatedTypeValidator.validateAnnotatedMember(field);
        return this.validateInjectionPoint(this.createFieldInjectionPoint(field));
    }

    private <X> FieldInjectionPointAttributes<?, X> createFieldInjectionPoint(AnnotatedField<X> field) {
        EnhancedAnnotatedField enhancedField = (EnhancedAnnotatedField)this.services.get(MemberTransformer.class).loadEnhancedMember(field, this.getId());
        return InferringFieldInjectionPointAttributes.of(enhancedField, null, field.getDeclaringType().getJavaClass(), this);
    }

    public ParameterInjectionPointAttributes<?, ?> createInjectionPoint(AnnotatedParameter<?> parameter) {
        AnnotatedTypeValidator.validateAnnotatedParameter(parameter);
        EnhancedAnnotatedParameter<?, ?> enhancedParameter = this.services.get(MemberTransformer.class).loadEnhancedParameter(parameter, this.getId());
        return this.validateInjectionPoint(InferringParameterInjectionPointAttributes.of(enhancedParameter, null, parameter.getDeclaringCallable().getDeclaringType().getJavaClass(), this));
    }

    private <T extends InjectionPoint> T validateInjectionPoint(T injectionPoint) {
        try {
            this.services.get(Validator.class).validateInjectionPointForDefinitionErrors(injectionPoint, null, this);
        }
        catch (DefinitionException e) {
            throw new IllegalArgumentException((Throwable)((Object)e));
        }
        return injectionPoint;
    }

    public <T extends Extension> T getExtension(Class<T> extensionClass) {
        Bean<?> bean = null;
        for (Bean<?> b : this.getBeans(extensionClass, new Annotation[0])) {
            if (!b.getBeanClass().equals(extensionClass)) continue;
            bean = b;
        }
        if (bean == null) {
            throw BeanManagerLogger.LOG.noInstanceOfExtension(extensionClass);
        }
        return (T)((Extension)extensionClass.cast(bean.create(null)));
    }

    public <T> InterceptionFactory<T> createInterceptionFactory(CreationalContext<T> ctx, Class<T> clazz) {
        return InterceptionFactoryImpl.of(this, ctx, this.createAnnotatedType(clazz));
    }

    public Event<Object> getEvent() {
        return this.event();
    }

    private boolean isRegisterableInjectionPoint(InjectionPoint ip) {
        return ip != null && !ip.getType().equals(InjectionPoint.class) && !ip.isDelegate();
    }

    public ContainerLifecycleEvents getContainerLifecycleEvents() {
        return this.containerLifecycleEvents;
    }

    public boolean areQualifiersEquivalent(Annotation qualifier1, Annotation qualifier2) {
        return Bindings.areQualifiersEquivalent(qualifier1, qualifier2, this.services.get(MetaAnnotationStore.class));
    }

    public boolean areInterceptorBindingsEquivalent(Annotation interceptorBinding1, Annotation interceptorBinding2) {
        return Bindings.areInterceptorBindingsEquivalent(interceptorBinding1, interceptorBinding2, this.services.get(MetaAnnotationStore.class));
    }

    public int getQualifierHashCode(Annotation qualifier) {
        return Bindings.getQualifierHashCode(qualifier, this.services.get(MetaAnnotationStore.class));
    }

    public int getInterceptorBindingHashCode(Annotation interceptorBinding) {
        return Bindings.getInterceptorBindingHashCode(interceptorBinding, this.services.get(MetaAnnotationStore.class));
    }

    public <T> InjectionTargetFactoryImpl<T> getLocalInjectionTargetFactory(AnnotatedType<T> type) {
        return new InjectionTargetFactoryImpl<T>(type, this);
    }

    @Override
    public <T> WeldInjectionTargetFactory<T> getInjectionTargetFactory(AnnotatedType<T> type) {
        AnnotatedTypeValidator.validateAnnotatedType(type);
        BeanManagerImpl manager = BeanManagerLookupService.lookupBeanManager(type.getJavaClass(), this);
        return new InjectionTargetFactoryImpl<T>(type, manager);
    }

    public <X> FieldProducerFactory<X> getProducerFactory(AnnotatedField<? super X> field, Bean<X> declaringBean) {
        BeanManagerImpl manager = BeanManagerLookupService.lookupBeanManager(field.getDeclaringType().getJavaClass(), this);
        return new FieldProducerFactory<X>(field, declaringBean, manager);
    }

    public <X> MethodProducerFactory<X> getProducerFactory(AnnotatedMethod<? super X> method, Bean<X> declaringBean) {
        BeanManagerImpl manager = BeanManagerLookupService.lookupBeanManager(method.getDeclaringType().getJavaClass(), this);
        return new MethodProducerFactory<X>(method, declaringBean, manager);
    }

    @Override
    public <T> WeldInjectionTargetBuilder<T> createInjectionTargetBuilder(AnnotatedType<T> type) {
        return new WeldInjectionTargetBuilderImpl<T>(type, this);
    }

    public WeldInstance<Object> createInstance() {
        return this.getInstance(this.createCreationalContext((Contextual)null));
    }

    private Bean<?> findNormalScopedDependant(CreationalContextImpl<?> weldCreationalContext) {
        WeldCreationalContext parent = weldCreationalContext.getParentCreationalContext();
        if (parent != null && ((CreationalContextImpl)parent).getContextual() instanceof Bean) {
            Bean bean = (Bean)((CreationalContextImpl)parent).getContextual();
            if (this.isNormalScope(bean.getScope())) {
                return bean;
            }
            return this.findNormalScopedDependant((CreationalContextImpl<?>)parent);
        }
        return null;
    }

    @Override
    public BeanManagerImpl unwrap() {
        return this;
    }

    public void fireRequestContextInitialized(Object payload) {
        this.requestInitializedEvent.get().fire(payload);
    }

    public void fireRequestContextBeforeDestroyed(Object payload) {
        this.requestBeforeDestroyedEvent.get().fire(payload);
    }

    public void fireRequestContextDestroyed(Object payload) {
        this.requestDestroyedEvent.get().fire(payload);
    }

    public void addValidationFailureCallback(BiConsumer<Exception, Environment> callback) {
        this.validationFailureCallbacks.add(callback);
    }

    public void validationFailed(Exception failure, Environment environment) {
        for (BiConsumer<Exception, Environment> callback : this.validationFailureCallbacks) {
            try {
                callback.accept(failure, environment);
            }
            catch (Throwable ignored) {
                BootstrapLogger.LOG.catchingDebug(ignored);
            }
        }
    }

    @Override
    public Collection<Class<? extends Annotation>> getScopes() {
        return Collections.unmodifiableCollection(this.contexts.keySet());
    }

    private void removeUnusedBeans() {
        String excludeTypeProperty = this.getServices().get(WeldConfiguration.class).getStringProperty(ConfigurationKey.UNUSED_BEANS_EXCLUDE_TYPE);
        if (ConfigurationKey.UnusedBeans.isEnabled(excludeTypeProperty)) {
            String excludeAnnotationProperty = this.getServices().get(WeldConfiguration.class).getStringProperty(ConfigurationKey.UNUSED_BEANS_EXCLUDE_ANNOTATION);
            Pattern excludeAnnotation = excludeAnnotationProperty.isEmpty() ? null : Pattern.compile(excludeAnnotationProperty);
            Pattern excludeType = ConfigurationKey.UnusedBeans.excludeNone(excludeTypeProperty) ? null : Pattern.compile(excludeTypeProperty);
            Validator validator = this.getServices().get(Validator.class);
            SetMultimap beanToDeclaredProducers = SetMultimap.newSetMultimap();
            SetMultimap beanToDeclaredObservers = SetMultimap.newSetMultimap();
            for (Bean<?> bean : this.enabledBeans) {
                if (!(bean instanceof AbstractProducerBean)) continue;
                AbstractProducerBean producer = (AbstractProducerBean)bean;
                beanToDeclaredProducers.put(producer.getDeclaringBean(), producer);
            }
            for (ObserverMethod observerMethod : this.observers) {
                if (!(observerMethod instanceof ObserverMethodImpl)) continue;
                ObserverMethodImpl observerMethodImpl = (ObserverMethodImpl)observerMethod;
                beanToDeclaredObservers.put(observerMethodImpl.getDeclaringBean(), observerMethod);
            }
            HashSet removable = new HashSet();
            HashSet hashSet = new HashSet();
            WeldUnusedMetadataExtension metadataExtension = this.getUnusedMetadataExtension();
            for (Bean<?> bean : this.enabledBeans) {
                if ((bean = Beans.unwrap(bean)) instanceof AbstractBuiltInBean || bean instanceof ExtensionBean || bean instanceof Interceptor || bean instanceof Decorator || bean instanceof SessionBean || bean.getName() != null || excludeType != null && excludeType.matcher(bean.getBeanClass().getName()).matches() || beanToDeclaredObservers.containsKey(bean) || beanToDeclaredProducers.containsKey(bean) || validator.isResolved(bean) || metadataExtension != null && (metadataExtension.isInjectedByEEComponent(bean, this) || metadataExtension.isInstanceResolvedBean(bean, this)) || excludeAnnotation != null && this.hasExcludeAnnotation(bean, excludeAnnotation)) continue;
                if (bean instanceof AbstractProducerBean) {
                    hashSet.add(bean);
                }
                BootstrapLogger.LOG.dropUnusedBeanMetadata(bean);
                removable.add(bean);
            }
            if (!hashSet.isEmpty()) {
                for (Bean<?> bean : beanToDeclaredProducers.keySet()) {
                    if (!hashSet.containsAll((Collection<?>)beanToDeclaredProducers.get(bean = Beans.unwrap(bean)))) continue;
                    BootstrapLogger.LOG.dropUnusedBeanMetadata(bean);
                    removable.add(bean);
                }
            }
            if (!removable.isEmpty()) {
                this.enabledBeans.removeAll(removable);
                this.sharedBeans.removeAll(removable);
                this.beanResolver.clear();
                this.cleanupBeansAfterBoot(removable);
                ((ContextualStoreImpl)this.getServices().get(ContextualStore.class)).removeAll(removable);
                this.getServices().get(ClassTransformer.class).removeAll(removable);
            }
        }
    }

    private void cleanupBeansAfterBoot(Iterable<Bean<?>> beans) {
        for (Bean<?> bean : beans) {
            if (!(bean instanceof RIBean)) continue;
            RIBean riBean = (RIBean)bean;
            riBean.cleanupAfterBoot();
        }
    }

    private boolean hasExcludeAnnotation(Bean<?> bean, Pattern excludeAnnotation) {
        if (bean instanceof AbstractClassBean) {
            return this.hasExcludeAnnotation((AbstractClassBean)bean, excludeAnnotation);
        }
        if (bean instanceof AbstractProducerBean) {
            return this.hasExcludeAnnotation(((AbstractProducerBean)bean).getDeclaringBean(), excludeAnnotation);
        }
        return false;
    }

    private boolean hasExcludeAnnotation(AbstractClassBean<?> classBean, Pattern excludeAnnotation) {
        SlimAnnotatedType<?> annotatedType = classBean.getAnnotated();
        return this.hasExcludeAnnotation((Annotated)annotatedType, excludeAnnotation) || this.anyHasExcludeAnnotation(annotatedType.getMethods(), excludeAnnotation) || this.anyHasExcludeAnnotation(annotatedType.getFields(), excludeAnnotation) || this.anyHasExcludeAnnotation(annotatedType.getConstructors(), excludeAnnotation);
    }

    private <E extends Annotated> boolean anyHasExcludeAnnotation(Set<E> annotatedSet, Pattern excludeAnnotation) {
        if (annotatedSet.isEmpty()) {
            return false;
        }
        for (Annotated annotated : annotatedSet) {
            if (!this.hasExcludeAnnotation(annotated, excludeAnnotation)) continue;
            return true;
        }
        return false;
    }

    private boolean hasExcludeAnnotation(Annotated annotated, Pattern excludeAnnotation) {
        for (Annotation annotation : annotated.getAnnotations()) {
            if (!excludeAnnotation.matcher(annotation.annotationType().getName()).matches()) continue;
            return true;
        }
        return false;
    }

    private WeldUnusedMetadataExtension getUnusedMetadataExtension() {
        try {
            return this.getExtension(WeldUnusedMetadataExtension.class);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    private static class EventInjectionPoint
    implements InjectionPoint,
    Serializable {
        private static final long serialVersionUID = 8947703643709929295L;
        private static final InjectionPoint INSTANCE = new EventInjectionPoint();
        private transient Type type;

        private EventInjectionPoint() {
        }

        public Type getType() {
            if (this.type == null) {
                this.type = new TypeLiteral<Event<Object>>(){}.getType();
            }
            return this.type;
        }

        public Set<Annotation> getQualifiers() {
            return Collections.emptySet();
        }

        public Bean<?> getBean() {
            return null;
        }

        public Member getMember() {
            return null;
        }

        public Annotated getAnnotated() {
            return null;
        }

        public boolean isDelegate() {
            return false;
        }

        public boolean isTransient() {
            return false;
        }
    }

    private static class InstanceInjectionPoint
    implements InjectionPoint,
    Serializable {
        private static final long serialVersionUID = -2952474261839554286L;
        private static final InjectionPoint INSTANCE = new InstanceInjectionPoint();
        private transient Type type;

        private InstanceInjectionPoint() {
        }

        public Type getType() {
            if (this.type == null) {
                this.type = new TypeLiteral<Instance<Object>>(){}.getType();
            }
            return this.type;
        }

        public Set<Annotation> getQualifiers() {
            return Collections.emptySet();
        }

        public Bean<?> getBean() {
            return null;
        }

        public Member getMember() {
            return null;
        }

        public Annotated getAnnotated() {
            return null;
        }

        public boolean isDelegate() {
            return false;
        }

        public boolean isTransient() {
            return false;
        }
    }
}

