/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.injection.producer;

import java.io.Serializable;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Member;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import javax.enterprise.context.Dependent;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.AnnotatedMember;
import javax.enterprise.inject.spi.Bean;
import org.jboss.weld.annotated.enhanced.EnhancedAnnotatedMember;
import org.jboss.weld.bean.ContextualInstance;
import org.jboss.weld.bean.DisposalMethod;
import org.jboss.weld.context.WeldCreationalContext;
import org.jboss.weld.exceptions.DefinitionException;
import org.jboss.weld.injection.producer.AbstractProducer;
import org.jboss.weld.logging.BeanLogger;
import org.jboss.weld.manager.BeanManagerImpl;

public abstract class AbstractMemberProducer<X, T>
extends AbstractProducer<T> {
    private final DisposalMethod<?, ?> disposalMethod;

    public AbstractMemberProducer(EnhancedAnnotatedMember<T, ? super X, ? extends Member> enhancedMember, DisposalMethod<?, ?> disposalMethod) {
        this.disposalMethod = disposalMethod;
        this.checkDeclaringBean();
        this.checkProducerReturnType(enhancedMember);
    }

    protected void checkDeclaringBean() {
        if (this.getDeclaringBean() == null && !this.getAnnotated().isStatic()) {
            throw BeanLogger.LOG.declaringBeanMissing(this.getAnnotated());
        }
    }

    protected void checkProducerReturnType(EnhancedAnnotatedMember<T, ? super X, ? extends Member> enhancedMember) {
        this.checkReturnTypeIsConcrete(enhancedMember, enhancedMember.getBaseType());
        this.checkReturnTypeForWildcardsAndTypeVariables(enhancedMember, enhancedMember.getBaseType());
    }

    private void checkReturnTypeIsConcrete(EnhancedAnnotatedMember<T, ? super X, ? extends Member> enhancedMember, Type type) {
        if (type instanceof TypeVariable || type instanceof WildcardType) {
            throw BeanLogger.LOG.returnTypeMustBeConcrete(enhancedMember);
        }
        if (type instanceof GenericArrayType) {
            GenericArrayType arrayType = (GenericArrayType)type;
            this.checkReturnTypeIsConcrete(enhancedMember, arrayType.getGenericComponentType());
        }
    }

    private void checkReturnTypeForWildcardsAndTypeVariables(EnhancedAnnotatedMember<T, ? super X, ? extends Member> enhancedMember, Type type) {
        if (type instanceof TypeVariable) {
            if (!this.isDependent()) {
                throw this.producerWithTypeVariableBeanTypeMustBeDependent(enhancedMember);
            }
        } else {
            if (type instanceof WildcardType) {
                throw this.producerCannotHaveWildcardBeanType(enhancedMember);
            }
            if (type instanceof ParameterizedType) {
                ParameterizedType parameterizedType = (ParameterizedType)type;
                for (Type parameterType : parameterizedType.getActualTypeArguments()) {
                    this.checkReturnTypeForWildcardsAndTypeVariables(enhancedMember, parameterType);
                }
            } else if (type instanceof GenericArrayType) {
                GenericArrayType arrayType = (GenericArrayType)type;
                this.checkReturnTypeForWildcardsAndTypeVariables(enhancedMember, arrayType.getGenericComponentType());
            }
        }
    }

    protected abstract DefinitionException producerCannotHaveWildcardBeanType(Object var1);

    protected abstract DefinitionException producerWithTypeVariableBeanTypeMustBeDependent(Object var1);

    private boolean isDependent() {
        return this.getBean() != null && Dependent.class.equals((Object)this.getBean().getScope());
    }

    protected Object getReceiver(CreationalContext<?> productCreationalContext, CreationalContext<?> receiverCreationalContext) {
        WeldCreationalContext creationalContextImpl;
        X incompleteInstance;
        if (this.getAnnotated().isStatic()) {
            return null;
        }
        if (productCreationalContext instanceof WeldCreationalContext && (incompleteInstance = (creationalContextImpl = (WeldCreationalContext)productCreationalContext).getIncompleteInstance(this.getDeclaringBean())) != null) {
            BeanLogger.LOG.circularCall(this.getAnnotated(), this.getDeclaringBean());
            return incompleteInstance;
        }
        return this.getBeanManager().getReference(this.getDeclaringBean(), null, receiverCreationalContext, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose(T instance) {
        if (this.disposalMethod != null) {
            if (this.getAnnotated().isStatic()) {
                this.disposalMethod.invokeDisposeMethod(null, instance, null);
            } else {
                org.jboss.weld.construction.api.WeldCreationalContext ctx = null;
                try {
                    X receiver = ContextualInstance.getIfExists(this.getDeclaringBean(), this.getBeanManager());
                    if (receiver == null) {
                        ctx = this.getBeanManager().createCreationalContext((Contextual)null);
                        receiver = ContextualInstance.get(this.getDeclaringBean(), this.getBeanManager(), ctx.getCreationalContext(this.getDeclaringBean()));
                    }
                    if (receiver != null) {
                        this.disposalMethod.invokeDisposeMethod(receiver, instance, ctx);
                    }
                }
                finally {
                    if (ctx != null) {
                        ctx.release();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T produce(CreationalContext<T> ctx) {
        CreationalContext<X> receiverCreationalContext = this.getReceiverCreationalContext(ctx);
        Object receiver = this.getReceiver(ctx, receiverCreationalContext);
        try {
            T t = this.produce(receiver, ctx);
            return t;
        }
        finally {
            receiverCreationalContext.release();
        }
    }

    private CreationalContext<X> getReceiverCreationalContext(CreationalContext<T> ctx) {
        if (ctx instanceof WeldCreationalContext) {
            return ((WeldCreationalContext)ctx).getProducerReceiverCreationalContext(this.getDeclaringBean());
        }
        return this.getBeanManager().createCreationalContext((Contextual)this.getDeclaringBean());
    }

    public DisposalMethod<?, ?> getDisposalMethod() {
        return this.disposalMethod;
    }

    protected boolean isTypeSerializable(Object object) {
        return object instanceof Serializable;
    }

    public abstract BeanManagerImpl getBeanManager();

    public abstract Bean<X> getDeclaringBean();

    @Override
    public abstract Bean<T> getBean();

    public abstract AnnotatedMember<? super X> getAnnotated();

    protected abstract T produce(Object var1, CreationalContext<T> var2);

    public String toString() {
        StringBuilder result = new StringBuilder("Producer for ");
        if (this.getDeclaringBean() == null) {
            result.append(this.getAnnotated());
        } else {
            if (this.getBean() == null) {
                result.append(this.getAnnotated());
            } else {
                result.append(this.getBean());
            }
            result.append(" declared on ").append(this.getDeclaringBean());
        }
        return result.toString();
    }
}

