/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.bean.attributes;

import java.beans.Introspector;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.enterprise.context.Dependent;
import javax.enterprise.context.NormalScope;
import javax.enterprise.inject.spi.BeanAttributes;
import javax.inject.Named;
import javax.inject.Qualifier;
import javax.inject.Scope;
import org.jboss.weld.annotated.enhanced.EnhancedAnnotated;
import org.jboss.weld.annotated.enhanced.EnhancedAnnotatedField;
import org.jboss.weld.annotated.enhanced.EnhancedAnnotatedMethod;
import org.jboss.weld.annotated.enhanced.EnhancedAnnotatedType;
import org.jboss.weld.bean.attributes.ImmutableBeanAttributes;
import org.jboss.weld.config.ConfigurationKey;
import org.jboss.weld.config.WeldConfiguration;
import org.jboss.weld.ejb.InternalEjbDescriptor;
import org.jboss.weld.literal.AnyLiteral;
import org.jboss.weld.literal.DefaultLiteral;
import org.jboss.weld.literal.NamedLiteral;
import org.jboss.weld.literal.NewLiteral;
import org.jboss.weld.logging.BeanLogger;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.metadata.cache.MergedStereotypes;
import org.jboss.weld.resources.SharedObjectCache;
import org.jboss.weld.util.Beans;
import org.jboss.weld.util.collections.ArraySet;
import org.jboss.weld.util.reflection.Reflections;

public class BeanAttributesFactory {
    private static final Set<Annotation> DEFAULT_QUALIFIERS = Collections.unmodifiableSet(new ArraySet<Annotation>(AnyLiteral.INSTANCE, DefaultLiteral.INSTANCE).trimToSize());

    private BeanAttributesFactory() {
    }

    public static <T> BeanAttributes<T> forBean(EnhancedAnnotated<T, ?> annotated, BeanManagerImpl manager) {
        return new BeanAttributesBuilder(annotated, null, manager).build();
    }

    public static <T> BeanAttributes<T> forSessionBean(EnhancedAnnotatedType<T> annotated, InternalEjbDescriptor<?> descriptor, BeanManagerImpl manager) {
        return new BeanAttributesBuilder(annotated, (InternalEjbDescriptor)Reflections.cast(descriptor), manager).build();
    }

    public static <T> BeanAttributes<T> forNewBean(Set<Type> types, Class<?> javaClass) {
        Set<NewLiteral> qualifiers = Collections.singleton(new NewLiteral(javaClass));
        return new ImmutableBeanAttributes(Collections.<Class<Annotation>>emptySet(), false, null, qualifiers, types, Dependent.class);
    }

    public static <T> BeanAttributes<T> forNewManagedBean(EnhancedAnnotatedType<T> weldClass, BeanManagerImpl manager) {
        return BeanAttributesFactory.forNewBean(SharedObjectCache.instance(manager).getSharedSet(Beans.getTypes(weldClass)), weldClass.getJavaClass());
    }

    public static <T> BeanAttributes<T> forNewSessionBean(BeanAttributes<T> originalAttributes, Class<?> javaClass) {
        return BeanAttributesFactory.forNewBean(originalAttributes.getTypes(), javaClass);
    }

    private static class BeanAttributesBuilder<T> {
        private MergedStereotypes<T, ?> mergedStereotypes;
        private boolean alternative;
        private String name;
        private Set<Annotation> qualifiers;
        private Set<Type> types;
        private Class<? extends Annotation> scope;
        private BeanManagerImpl manager;

        private BeanAttributesBuilder(EnhancedAnnotated<T, ?> annotated, InternalEjbDescriptor<T> descriptor, BeanManagerImpl manager) {
            this.manager = manager;
            this.initStereotypes(annotated, manager);
            this.initAlternative(annotated);
            this.initName(annotated);
            this.initQualifiers(annotated);
            this.initScope(annotated);
            this.types = descriptor == null ? SharedObjectCache.instance(manager).getSharedSet(Beans.getTypes(annotated)) : SharedObjectCache.instance(manager).getSharedSet(Beans.getTypes(annotated, descriptor));
        }

        protected <S> void initStereotypes(EnhancedAnnotated<T, S> annotated, BeanManagerImpl manager) {
            this.mergedStereotypes = MergedStereotypes.of(annotated, manager);
        }

        protected void initAlternative(EnhancedAnnotated<T, ?> annotated) {
            this.alternative = Beans.isAlternative(annotated, this.mergedStereotypes);
        }

        protected void initName(EnhancedAnnotated<T, ?> annotated) {
            boolean beanNameDefaulted = false;
            if (annotated.isAnnotationPresent(Named.class)) {
                String javaName = ((Named)annotated.getAnnotation(Named.class)).value();
                if ("".equals(javaName)) {
                    beanNameDefaulted = true;
                } else {
                    this.name = javaName;
                    return;
                }
            }
            if (beanNameDefaulted || this.mergedStereotypes != null && this.mergedStereotypes.isBeanNameDefaulted()) {
                this.name = this.getDefaultName(annotated);
            }
        }

        protected String getDefaultName(EnhancedAnnotated<?, ?> annotated) {
            if (annotated instanceof EnhancedAnnotatedType) {
                if (this.manager.getServices().get(WeldConfiguration.class).getBooleanProperty(ConfigurationKey.DEFAULT_BEAN_NAMES_FOLLOW_JAVABEAN_RULES).booleanValue()) {
                    return Introspector.decapitalize(((EnhancedAnnotatedType)annotated).getSimpleName());
                }
                StringBuilder defaultNameBuilder = new StringBuilder(((EnhancedAnnotatedType)annotated).getSimpleName());
                defaultNameBuilder.setCharAt(0, Character.toLowerCase(defaultNameBuilder.charAt(0)));
                return defaultNameBuilder.toString();
            }
            if (annotated instanceof EnhancedAnnotatedField) {
                return ((EnhancedAnnotatedField)annotated).getPropertyName();
            }
            if (annotated instanceof EnhancedAnnotatedMethod) {
                return ((EnhancedAnnotatedMethod)annotated).getPropertyName();
            }
            return null;
        }

        protected void initQualifiers(Set<Annotation> qualifiers) {
            if (qualifiers.isEmpty()) {
                this.qualifiers = DEFAULT_QUALIFIERS;
            } else {
                ArraySet<Object> normalizedQualifiers = new ArraySet<Object>(qualifiers.size() + 2);
                if (qualifiers.size() == 1 && qualifiers.iterator().next().annotationType().equals(Named.class)) {
                    normalizedQualifiers.add(DefaultLiteral.INSTANCE);
                }
                normalizedQualifiers.addAll((Collection<Object>)qualifiers);
                normalizedQualifiers.add(AnyLiteral.INSTANCE);
                if (this.name != null && normalizedQualifiers.remove(NamedLiteral.DEFAULT)) {
                    normalizedQualifiers.add((Object)new NamedLiteral(this.name));
                }
                this.qualifiers = SharedObjectCache.instance(this.manager).getSharedSet(normalizedQualifiers);
            }
        }

        protected void initQualifiers(EnhancedAnnotated<?, ?> annotated) {
            this.initQualifiers(annotated.getMetaAnnotations(Qualifier.class));
        }

        protected void initScope(EnhancedAnnotated<T, ?> annotated) {
            if (annotated instanceof EnhancedAnnotatedType) {
                EnhancedAnnotatedType weldClass;
                for (EnhancedAnnotatedType clazz = weldClass = (EnhancedAnnotatedType)annotated; clazz != null; clazz = clazz.getEnhancedSuperclass()) {
                    HashSet<Annotation> scopes = new HashSet<Annotation>();
                    scopes.addAll(clazz.getDeclaredMetaAnnotations(Scope.class));
                    scopes.addAll(clazz.getDeclaredMetaAnnotations(NormalScope.class));
                    this.validateScopeSet(scopes, annotated);
                    if (scopes.size() != 1) continue;
                    if (annotated.isAnnotationPresent(((Annotation)scopes.iterator().next()).annotationType())) {
                        this.scope = ((Annotation)scopes.iterator().next()).annotationType();
                    }
                    break;
                }
            } else {
                HashSet<Annotation> scopes = new HashSet<Annotation>();
                scopes.addAll(annotated.getMetaAnnotations(Scope.class));
                scopes.addAll(annotated.getMetaAnnotations(NormalScope.class));
                if (scopes.size() == 1) {
                    this.scope = ((Annotation)scopes.iterator().next()).annotationType();
                }
                this.validateScopeSet(scopes, annotated);
            }
            if (this.scope == null) {
                this.initScopeFromStereotype();
            }
            if (this.scope == null) {
                this.scope = Dependent.class;
            }
        }

        protected void validateScopeSet(Set<Annotation> scopes, EnhancedAnnotated<T, ?> annotated) {
            if (scopes.size() > 1) {
                throw BeanLogger.LOG.onlyOneScopeAllowed(annotated);
            }
        }

        protected boolean initScopeFromStereotype() {
            Set<Annotation> possibleScopes = this.mergedStereotypes.getPossibleScopes();
            if (possibleScopes.size() == 1) {
                this.scope = possibleScopes.iterator().next().annotationType();
                return true;
            }
            if (possibleScopes.size() > 1) {
                throw BeanLogger.LOG.multipleScopesFoundFromStereotypes(this.mergedStereotypes);
            }
            return false;
        }

        public BeanAttributes<T> build() {
            return new ImmutableBeanAttributes(this.mergedStereotypes.getStereotypes(), this.alternative, this.name, this.qualifiers, this.types, this.scope);
        }
    }
}

