/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.probe;

import java.lang.annotation.Annotation;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.ObserverMethod;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.probe.Components;
import org.jboss.weld.probe.Invocation;
import org.jboss.weld.probe.Json;
import org.jboss.weld.probe.JsonDataProvider;
import org.jboss.weld.probe.JsonObjects;
import org.jboss.weld.probe.Probe;
import org.jboss.weld.probe.Queries;
import org.jboss.weld.probe.Resource;

public class DefaultJsonDataProvider
implements JsonDataProvider {
    private final Probe probe;
    private final BeanManagerImpl beanManager;

    DefaultJsonDataProvider(Probe probe, BeanManagerImpl beanManager) {
        this.probe = probe;
        this.beanManager = beanManager;
    }

    @Override
    public String receiveDeployment() {
        return JsonObjects.createDeploymentJson(this.beanManager, this.probe);
    }

    @Override
    public String receiveBeans(int pageIndex, int pageSize, String filters, String representation) {
        return JsonObjects.createBeansJson(Queries.find(this.probe.getBeans(), pageIndex, pageSize, Queries.initFilters(filters, new Queries.BeanFilters(this.probe))), this.probe, this.beanManager, Resource.Representation.from(representation));
    }

    @Override
    public String receiveBean(String id, boolean transientDependencies, boolean transientDependents) {
        Bean<?> bean = this.probe.getBean(id);
        return bean != null ? JsonObjects.createFullBeanJson(bean, transientDependencies, transientDependents, this.beanManager, this.probe) : null;
    }

    @Override
    public String receiveBeanInstance(String id) {
        Object instance;
        Bean<?> bean = this.probe.getBean(id);
        if (bean != null && Components.isInspectableScope(bean.getScope()) && (instance = Components.findContextualInstance(bean, this.beanManager)) != null) {
            return JsonObjects.createContextualInstanceJson(bean, instance, this.probe);
        }
        return null;
    }

    @Override
    public String receiveObservers(int pageIndex, int pageSize, String filters) {
        return JsonObjects.createObserversJson(Queries.find(this.probe.getObservers(), pageIndex, pageSize, Queries.initFilters(filters, new Queries.ObserverFilters(this.probe))), this.probe);
    }

    @Override
    public String receiveObserver(String id) {
        ObserverMethod<?> observer = this.probe.getObserver(id);
        if (observer != null) {
            return JsonObjects.createFullObserverJson(observer, this.probe);
        }
        return null;
    }

    @Override
    public String receiveContexts() {
        return JsonObjects.createContextsJson(this.beanManager, this.probe).build();
    }

    @Override
    public String receiveContext(String id) {
        Class<? extends Annotation> scope = Components.INSPECTABLE_SCOPES.get(id);
        if (scope != null) {
            return JsonObjects.createContextJson(id, scope, this.beanManager, this.probe, null).build();
        }
        return null;
    }

    @Override
    public String receiveInvocations(int pageIndex, int pageSize, String filters) {
        return JsonObjects.createInvocationsJson(Queries.find(this.probe.getInvocations(), pageIndex, pageSize, Queries.initFilters(filters, new Queries.InvocationsFilters(this.probe))), this.probe);
    }

    @Override
    public String clearInvocations() {
        return Json.objectBuilder().add("removedInvocations", this.probe.clearInvocations()).build();
    }

    @Override
    public String receiveInvocation(String id) {
        Invocation entryPoint = this.probe.getInvocation(id);
        if (entryPoint != null) {
            return JsonObjects.createFullInvocationJson(entryPoint, this.probe).build();
        }
        return null;
    }

    @Override
    public String receiveEvents(int pageIndex, int pageSize, String filters) {
        return JsonObjects.createEventsJson(Queries.find(this.probe.getEvents(), pageIndex, pageSize, Queries.initFilters(filters, new Queries.EventsFilters(this.probe))), this.probe);
    }

    @Override
    public String clearEvents() {
        return Json.objectBuilder().add("removedEvents", this.probe.clearEvents()).build();
    }
}

