/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.solder.servlet.webxml;

import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import org.jboss.solder.logging.Logger;
import org.jboss.solder.servlet.webxml.WebXmlLocator;

public class URLClassLoaderWebXmlLocator
implements WebXmlLocator {
    private final Logger log = Logger.getLogger(URLClassLoaderWebXmlLocator.class);

    public int getPrecedence() {
        return 100;
    }

    public URL getWebXmlLocation(ClassLoader classLoader) {
        if (classLoader instanceof URLClassLoader) {
            URLClassLoader urlClassLoader = (URLClassLoader)classLoader;
            for (URL classLoaderUrl : urlClassLoader.getURLs()) {
                URL possibleWebXmlLocation = this.processClassLoaderSearchPath(classLoaderUrl);
                if (possibleWebXmlLocation == null) continue;
                return possibleWebXmlLocation;
            }
        } else if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("Context class loader is not an URLClassLoader but: " + (classLoader != null ? classLoader.getClass().getName() : "null")));
        }
        return null;
    }

    private URL processClassLoaderSearchPath(URL classPathUrl) {
        block6: {
            String location = classPathUrl.toString();
            if (location.endsWith(".jar")) {
                return null;
            }
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("Found URL of directory: " + location));
            }
            try {
                if (location.endsWith("/WEB-INF/classes/")) {
                    return new URL(location.replaceAll("classes/$", "web.xml"));
                }
                if (location.endsWith("/target/classes/")) {
                    return new URL(location.replaceAll("target/classes/$", "src/main/webapp/WEB-INF/web.xml"));
                }
            }
            catch (MalformedURLException e) {
                if (!this.log.isDebugEnabled()) break block6;
                this.log.debug((Object)"Failed to create URL instance!", (Throwable)e);
            }
        }
        return null;
    }
}

