/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.solder.config.xml.model;

import java.util.HashSet;
import java.util.Set;
import javax.enterprise.inject.spi.BeanManager;
import org.jboss.solder.config.xml.core.BeanResult;
import org.jboss.solder.config.xml.model.AbstractXmlItem;
import org.jboss.solder.config.xml.model.KeyXmlItem;
import org.jboss.solder.config.xml.model.ValueXmlItem;
import org.jboss.solder.config.xml.model.XmlItem;
import org.jboss.solder.config.xml.model.XmlItemType;
import org.jboss.solder.config.xml.util.TypeOccuranceInformation;
import org.jboss.solder.config.xml.util.XmlConfigurationException;

public class EntryXmlItem
extends AbstractXmlItem {
    final Set<TypeOccuranceInformation> allowed = new HashSet<TypeOccuranceInformation>();
    KeyXmlItem key;
    ValueXmlItem value;

    public EntryXmlItem(XmlItem parent, String document, int lineno) {
        super(XmlItemType.ENTRY, parent, null, null, null, document, lineno);
        this.allowed.add(TypeOccuranceInformation.of(XmlItemType.VALUE, 1, 1));
        this.allowed.add(TypeOccuranceInformation.of(XmlItemType.KEY, 1, 1));
    }

    @Override
    public Set<TypeOccuranceInformation> getAllowedItem() {
        return this.allowed;
    }

    @Override
    public boolean resolveChildren(BeanManager manager) {
        if (this.children.size() != 2) {
            throw new XmlConfigurationException("<entry> tags must have two children, a <key> and a <value>", this.getDocument(), this.getLineno());
        }
        for (XmlItem i : this.children) {
            if (i.getType() == XmlItemType.VALUE) {
                if (this.value != null) {
                    throw new XmlConfigurationException("<entry> tags must have two children, a <key> and a <value>", this.getDocument(), this.getLineno());
                }
                this.value = (ValueXmlItem)i;
                continue;
            }
            if (i.getType() != XmlItemType.KEY) continue;
            if (this.key != null) {
                throw new XmlConfigurationException("<entry> tags must have two children, a <key> and a <value>", this.getDocument(), this.getLineno());
            }
            this.key = (KeyXmlItem)i;
        }
        return true;
    }

    public KeyXmlItem getKey() {
        return this.key;
    }

    public ValueXmlItem getValue() {
        return this.value;
    }

    public Set<BeanResult<?>> getBeanResults(BeanManager manager) {
        HashSet ret = new HashSet();
        BeanResult<?> r = this.value.getBeanResult(manager);
        if (r != null) {
            ret.add(r);
        }
        if ((r = this.key.getBeanResult(manager)) != null) {
            ret.add(r);
        }
        return ret;
    }
}

