/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.solder.bean.defaultbean;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.HashSet;
import java.util.Set;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.PassivationCapable;
import org.jboss.solder.bean.ForwardingBean;
import org.jboss.solder.bean.defaultbean.DefaultBean;

abstract class AbstractDefaultBean<T>
extends ForwardingBean<T>
implements PassivationCapable {
    private final Bean<T> delegate;
    private final Set<Annotation> qualifiers;
    private final Set<Type> types;
    private final BeanManager beanManager;
    private final Type declaringBeanType;

    protected AbstractDefaultBean(Bean<T> delegate, Type declaringBeanType, Set<Type> types, Set<Annotation> qualifiers, BeanManager beanManager) {
        this.delegate = delegate;
        this.beanManager = beanManager;
        this.qualifiers = new HashSet<Annotation>(qualifiers);
        this.types = new HashSet<Type>(types);
        this.declaringBeanType = declaringBeanType;
    }

    protected BeanManager getBeanManager() {
        return this.beanManager;
    }

    @Override
    protected Bean<T> delegate() {
        return this.delegate;
    }

    protected Type getDeclaringBeanType() {
        return this.declaringBeanType;
    }

    @Override
    public Set<Annotation> getQualifiers() {
        return this.qualifiers;
    }

    public String getId() {
        if (this.delegate instanceof PassivationCapable) {
            return DefaultBean.class.getName() + "-" + ((PassivationCapable)this.delegate).getId();
        }
        return DefaultBean.class.getName() + "-" + this.types.toString() + "-QUALIFIERS-" + this.delegate.getQualifiers().toString();
    }

    @Override
    public String toString() {
        return "Default Bean with types " + this.types + " and qualifiers " + this.qualifiers;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.qualifiers == null ? 0 : this.qualifiers.hashCode());
        result = 31 * result + (this.types == null ? 0 : this.types.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractDefaultBean other = (AbstractDefaultBean)obj;
        if (this.qualifiers == null ? other.qualifiers != null : !this.qualifiers.equals(other.qualifiers)) {
            return false;
        }
        if (this.types == null ? other.types != null : !this.types.equals(other.types)) {
            return false;
        }
        return this.delegate.equals(other.delegate);
    }
}

