/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.solder.bean;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.enterprise.context.Dependent;
import javax.enterprise.inject.Alternative;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.inject.Named;
import org.jboss.solder.bean.ImmutableNarrowingBean;
import org.jboss.solder.bean.ImmutablePassivationCapableNarrowingBean;
import org.jboss.solder.literal.AnyLiteral;
import org.jboss.solder.literal.DefaultLiteral;
import org.jboss.solder.util.collections.Arrays2;

public class NarrowingBeanBuilder<T> {
    private final Bean<Object> delegate;
    private final BeanManager beanManager;
    private Set<Type> types;
    private Set<Annotation> qualifiers;
    private String name;
    private Class<? extends Annotation> scope;
    private boolean alternative;
    private boolean nullable;
    private String toString;
    private Set<Class<? extends Annotation>> stereotypes;
    private boolean passivationCapable;
    private String id;

    public static <T> NarrowingBeanBuilder<T> of(Bean<Object> delegate, BeanManager beanManager) {
        return new NarrowingBeanBuilder<T>(delegate, beanManager);
    }

    public NarrowingBeanBuilder(Bean<Object> delegate, BeanManager beanManager) {
        this.delegate = delegate;
        this.beanManager = beanManager;
    }

    public NarrowingBeanBuilder<T> readFromType(AnnotatedType<T> type) {
        this.types = new HashSet<Type>(type.getTypeClosure());
        this.qualifiers = new HashSet<Annotation>();
        this.stereotypes = new HashSet<Class<? extends Annotation>>();
        String name = null;
        Class scope = Dependent.class;
        for (Annotation annotation : type.getAnnotations()) {
            if (this.beanManager.isQualifier(annotation.annotationType())) {
                this.qualifiers.add(annotation);
                continue;
            }
            if (annotation.annotationType().equals(Named.class)) {
                name = ((Named)Named.class.cast(annotation)).value();
                continue;
            }
            if (this.beanManager.isScope(annotation.annotationType())) {
                scope = annotation.annotationType();
                continue;
            }
            if (!this.beanManager.isStereotype(annotation.annotationType())) continue;
            this.stereotypes.add(annotation.annotationType());
        }
        if (this.qualifiers.isEmpty()) {
            this.qualifiers.add((Annotation)DefaultLiteral.INSTANCE);
        }
        this.qualifiers.add((Annotation)AnyLiteral.INSTANCE);
        this.name = "".equals(name) ? null : name;
        this.scope = scope;
        this.alternative = type.isAnnotationPresent(Alternative.class);
        return this;
    }

    public Set<Type> getTypes() {
        return this.types;
    }

    public NarrowingBeanBuilder<T> types(Set<Type> types) {
        this.types = types;
        return this;
    }

    public NarrowingBeanBuilder<T> types(Type ... types) {
        this.types = Arrays2.asSet(types);
        return this;
    }

    public NarrowingBeanBuilder<T> addType(Type type) {
        this.types.add(type);
        return this;
    }

    public NarrowingBeanBuilder<T> addTypes(Type ... types) {
        this.types.addAll(Arrays2.asSet(types));
        return this;
    }

    public NarrowingBeanBuilder<T> addTypes(Collection<Type> types) {
        this.types.addAll(types);
        return this;
    }

    public Set<Annotation> getQualifiers() {
        return this.qualifiers;
    }

    public NarrowingBeanBuilder<T> qualifiers(Set<Annotation> qualifiers) {
        this.qualifiers = qualifiers;
        return this;
    }

    public NarrowingBeanBuilder<T> qualifiers(Annotation ... qualifiers) {
        this.qualifiers = Arrays2.asSet(qualifiers);
        return this;
    }

    public NarrowingBeanBuilder<T> addQualifier(Annotation qualifier) {
        this.qualifiers.add(qualifier);
        return this;
    }

    public NarrowingBeanBuilder<T> addQualifiers(Annotation ... qualifiers) {
        this.qualifiers.addAll(Arrays2.asSet(qualifiers));
        return this;
    }

    public NarrowingBeanBuilder<T> addQualifiers(Collection<Annotation> qualifiers) {
        this.qualifiers.addAll(qualifiers);
        return this;
    }

    public String getName() {
        return this.name;
    }

    public NarrowingBeanBuilder<T> name(String name) {
        this.name = name;
        return this;
    }

    public Class<? extends Annotation> getScope() {
        return this.scope;
    }

    public NarrowingBeanBuilder<T> scope(Class<? extends Annotation> scope) {
        this.scope = scope;
        return this;
    }

    public boolean isAlternative() {
        return this.alternative;
    }

    public NarrowingBeanBuilder<T> alternative(boolean alternative) {
        this.alternative = alternative;
        return this;
    }

    public Set<Class<? extends Annotation>> getStereotypes() {
        return this.stereotypes;
    }

    public NarrowingBeanBuilder<T> stereotypes(Set<Class<? extends Annotation>> stereotypes) {
        this.stereotypes = stereotypes;
        return this;
    }

    public ImmutableNarrowingBean<T> create() {
        if (this.isPassivationCapable()) {
            return new ImmutablePassivationCapableNarrowingBean(this.delegate, this.name, this.qualifiers, this.scope, this.stereotypes, this.types, this.alternative, this.nullable, this.toString, this.id);
        }
        return new ImmutableNarrowingBean(this.delegate, this.name, this.qualifiers, this.scope, this.stereotypes, this.types, this.alternative, this.nullable, this.toString);
    }

    public String getToString() {
        return this.toString;
    }

    public NarrowingBeanBuilder<T> toString(String toString) {
        this.toString = toString;
        return this;
    }

    public boolean isNullable() {
        return this.nullable;
    }

    public NarrowingBeanBuilder<T> nullable(boolean nullable) {
        this.nullable = nullable;
        return this;
    }

    public boolean isPassivationCapable() {
        return this.passivationCapable;
    }

    public NarrowingBeanBuilder<T> passivationCapable(boolean passivationCapable) {
        this.passivationCapable = passivationCapable;
        return this;
    }

    public String getId() {
        return this.id;
    }

    public NarrowingBeanBuilder<T> id(String id) {
        this.id = id;
        return this;
    }
}

