/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.impl.base.serialization;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OptionalDataException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.Assignable;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.exporter.ZipExporter;
import org.jboss.shrinkwrap.api.importer.ZipImporter;
import org.jboss.shrinkwrap.api.serialization.ZipSerializableView;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.shrinkwrap.impl.base.Validate;
import org.jboss.shrinkwrap.impl.base.io.IOUtil;
import org.jboss.shrinkwrap.spi.Identifiable;

public class ZipSerializableViewImpl
implements ZipSerializableView {
    private static final long serialVersionUID = 1L;
    private static final Logger log = Logger.getLogger(ZipSerializableViewImpl.class.getName());
    private final String name;
    private final transient String id;
    private transient Archive<?> archive;

    public ZipSerializableViewImpl(Archive<?> archive) {
        Validate.notNull(archive, "Archive must be specified");
        String name = archive.getName();
        Validate.notNullOrEmpty(name, "Name of archive must be specified");
        this.archive = archive;
        this.name = name;
        this.id = archive.getId();
    }

    public <TYPE extends Assignable> TYPE as(Class<TYPE> clazz) {
        return (TYPE)this.archive.as(clazz);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        try (InputStream in = ((ZipExporter)this.archive.as(ZipExporter.class)).exportAsInputStream();){
            IOUtil.copy(in, out);
            out.writeObject(this.id);
        }
        if (log.isLoggable(Level.FINER)) {
            log.finer("Wrote archive: " + this.archive.toString());
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        block4: {
            in.defaultReadObject();
            String name = this.name;
            ZipImporter archive = (ZipImporter)ShrinkWrap.create(ZipImporter.class, (String)name);
            archive.importFrom((InputStream)in);
            this.archive = (Archive)archive.as(JavaArchive.class);
            if (log.isLoggable(Level.FINER)) {
                log.finer("Read in archive: " + archive);
            }
            while (in.read() != -1) {
            }
            try {
                String id = (String)in.readObject();
                ((Identifiable)this.archive.as(Identifiable.class)).setId(id);
            }
            catch (OptionalDataException ode) {
                if (!log.isLoggable(Level.FINER)) break block4;
                log.finer("Detected an older version of the archive sent over the wire; no ID was sent.  Ignoring and using the default ID for this archive: " + archive);
            }
        }
    }
}

