/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.impl.base.nio2.file;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileTime;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ArchivePath;
import org.jboss.shrinkwrap.api.ArchivePaths;
import org.jboss.shrinkwrap.api.Node;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.impl.base.nio2.file.ShrinkWrapFileSystem;
import org.jboss.shrinkwrap.impl.base.nio2.file.ShrinkWrapPath;

final class ShrinkWrapFileAttributes
implements BasicFileAttributes {
    private final ShrinkWrapPath path;
    private final Archive<?> archive;

    ShrinkWrapFileAttributes(ShrinkWrapPath path, Archive<?> archive) {
        assert (path != null) : "Path must be specified";
        assert (archive != null) : "Archive must be specified";
        this.path = path;
        this.archive = archive;
    }

    @Override
    public FileTime lastModifiedTime() {
        throw new UnsupportedOperationException();
    }

    @Override
    public FileTime lastAccessTime() {
        throw new UnsupportedOperationException();
    }

    @Override
    public FileTime creationTime() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isRegularFile() {
        return !this.isDirectory();
    }

    @Override
    public boolean isDirectory() {
        ArchivePath archivePath = ArchivePaths.create((String)this.path.toString());
        Node node = this.archive.get(archivePath);
        return node.getAsset() == null;
    }

    @Override
    public boolean isSymbolicLink() {
        return false;
    }

    @Override
    public boolean isOther() {
        return false;
    }

    @Override
    public long size() {
        if (this.isDirectory()) {
            return -1L;
        }
        Asset asset = this.getArchive().get(this.path.toString()).getAsset();
        InputStream stream = asset.openStream();
        int totalRead = 0;
        byte[] buffer = new byte[4096];
        int read = 0;
        try {
            while ((read = stream.read(buffer, 0, buffer.length)) != -1) {
                totalRead += read;
            }
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        return totalRead;
    }

    @Override
    public Object fileKey() {
        return this.getArchive().getId() + "/" + this.path;
    }

    private Archive<?> getArchive() {
        return ((ShrinkWrapFileSystem)this.path.getFileSystem()).getArchive();
    }
}

