/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.api.formatter;

import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.Node;
import org.jboss.shrinkwrap.api.formatter.Formatter;

enum VerboseFormatter implements Formatter
{
    INSTANCE;

    private static final String ROOT = "/";

    @Override
    public String format(Archive<?> archive) throws IllegalArgumentException {
        if (archive == null) {
            throw new IllegalArgumentException("archive must be specified");
        }
        StringBuilder sb = new StringBuilder(archive.getName()).append(':').append('\n');
        Node rootNode = archive.get(ROOT);
        for (Node child : rootNode.getChildren()) {
            this.format(sb, child);
        }
        sb.deleteCharAt(sb.length() - 1);
        return sb.toString();
    }

    private void format(StringBuilder sb, Node node) {
        sb.append(node.getPath().get());
        if (node.getAsset() == null) {
            sb.append('/');
        }
        sb.append('\n');
        for (Node child : node.getChildren()) {
            this.format(sb, child);
        }
    }
}

