/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.api.asset;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;

class ByteArrayIOUtil {
    private static final Logger log = Logger.getLogger(ByteArrayIOUtil.class.getName());

    ByteArrayIOUtil() {
    }

    static byte[] asByteArray(InputStream in) throws IllegalArgumentException {
        if (in == null) {
            throw new IllegalArgumentException("stream must be specified");
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream(8192);
        int len = 4096;
        byte[] buffer = new byte[4096];
        int read = 0;
        try {
            while ((read = in.read(buffer)) != -1) {
                out.write(buffer, 0, read);
            }
        }
        catch (IOException ioe) {
            throw new RuntimeException("Error in obtaining bytes from " + in, ioe);
        }
        finally {
            block12: {
                try {
                    in.close();
                }
                catch (IOException exception) {
                    if (!log.isLoggable(Level.FINER)) break block12;
                    log.finer("Could not close stream due to: " + exception.getMessage() + "; ignoring");
                }
            }
        }
        byte[] content = out.toByteArray();
        return content;
    }
}

