/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.api.asset;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import org.jboss.shrinkwrap.api.asset.SecurityActions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ApiTestUtils {
    ApiTestUtils() {
    }

    static String convertToString(InputStream in) throws Exception {
        int b;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        while ((b = in.read()) != -1) {
            out.write(b);
        }
        out.close();
        in.close();
        return new String(out.toByteArray(), "UTF-8");
    }

    static int findLengthOfStream(InputStream in) throws Exception {
        int length = 0;
        while (in.read() != -1) {
            ++length;
        }
        in.close();
        return length;
    }

    static int findLengthOfClass(Class<?> clazz) throws Exception {
        String classResourceName = ApiTestUtils.getResourceNameForClass(clazz);
        InputStream in = SecurityActions.getThreadContextClassLoader().getResourceAsStream(classResourceName);
        return ApiTestUtils.findLengthOfStream(in);
    }

    static String getResourceNameForClass(Class<?> clazz) {
        String classResourceDelimiter = clazz.getName().replaceAll("\\.", "/");
        String classFullPath = classResourceDelimiter + ".class";
        return classFullPath;
    }
}

