/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.resolver.api;

import java.io.File;
import org.jboss.shrinkwrap.resolver.api.ConfigurableResolverSystem;
import org.jboss.shrinkwrap.resolver.api.InvalidConfigurationFileException;
import org.jboss.shrinkwrap.resolver.api.ResolverSystem;
import org.jboss.shrinkwrap.resolver.api.Resolvers;
import org.jboss.shrinkwrap.resolver.api.SecurityActions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfiguredResolverSystemFactory<RESOLVERSYSTEMTYPE extends ResolverSystem, CONFIGURABLERESOLVERSYSTEMTYPE extends ConfigurableResolverSystem<RESOLVERSYSTEMTYPE>> {
    private final Class<CONFIGURABLERESOLVERSYSTEMTYPE> clazz;
    private final ClassLoader clForCreation;

    public ConfiguredResolverSystemFactory(Class<CONFIGURABLERESOLVERSYSTEMTYPE> type) throws IllegalArgumentException {
        this(type, SecurityActions.getThreadContextClassLoader());
    }

    public ConfiguredResolverSystemFactory(Class<CONFIGURABLERESOLVERSYSTEMTYPE> type, ClassLoader clForCreation) throws IllegalArgumentException {
        if (type == null) {
            throw new IllegalArgumentException("Resolver system class must be specified");
        }
        if (clForCreation == null) {
            throw new IllegalArgumentException("ClassLoader is required");
        }
        this.clazz = type;
        this.clForCreation = clForCreation;
    }

    public RESOLVERSYSTEMTYPE fromFile(File file) throws IllegalArgumentException, InvalidConfigurationFileException {
        if (file == null) {
            throw new IllegalArgumentException("file must be specified");
        }
        if (!file.exists()) {
            throw new IllegalArgumentException("file specified does not exist: " + file.getAbsolutePath());
        }
        if (file.isDirectory()) {
            throw new IllegalArgumentException("file specified is a directory: " + file.getAbsolutePath());
        }
        CONFIGURABLERESOLVERSYSTEMTYPE resolverSystem = this.create();
        return (RESOLVERSYSTEMTYPE)resolverSystem.configureFromFile(file);
    }

    public RESOLVERSYSTEMTYPE fromFile(String pathToFile) throws IllegalArgumentException, InvalidConfigurationFileException {
        if (pathToFile == null || pathToFile.length() == 0) {
            throw new IllegalArgumentException("path to file must be specified");
        }
        File file = new File(pathToFile);
        return this.fromFile(file);
    }

    public RESOLVERSYSTEMTYPE fromClassloaderResource(String path) throws IllegalArgumentException, InvalidConfigurationFileException {
        return this.fromClassloaderResource(path, SecurityActions.getThreadContextClassLoader());
    }

    public RESOLVERSYSTEMTYPE fromClassloaderResource(String path, ClassLoader loader) throws IllegalArgumentException, InvalidConfigurationFileException {
        if (path == null || path.length() == 0) {
            throw new IllegalArgumentException("path to resource must be specified");
        }
        if (loader == null) {
            throw new IllegalArgumentException("ClassLoader must be specified");
        }
        CONFIGURABLERESOLVERSYSTEMTYPE resolverSystem = this.create();
        return (RESOLVERSYSTEMTYPE)resolverSystem.configureFromClassloaderResource(path, loader);
    }

    protected CONFIGURABLERESOLVERSYSTEMTYPE create() {
        return (CONFIGURABLERESOLVERSYSTEMTYPE)((ConfigurableResolverSystem)Resolvers.use(this.clazz, this.clForCreation));
    }
}

