/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.client.spring;

import java.net.URI;
import org.apache.http.client.HttpClient;
import org.jboss.resteasy.client.jaxrs.ClientHttpEngine;
import org.jboss.resteasy.client.jaxrs.ResteasyClientBuilder;
import org.jboss.resteasy.client.jaxrs.ResteasyWebTarget;
import org.jboss.resteasy.client.jaxrs.engines.ApacheHttpClient4Engine;
import org.jboss.resteasy.plugins.providers.RegisterBuiltin;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;

public class RestClientProxyFactoryBean<T>
implements FactoryBean<T>,
InitializingBean {
    private Class<T> serviceInterface;
    private URI baseUri;
    private T client;
    private HttpClient httpClient;
    private ClientHttpEngine clientEngine;
    private ResteasyProviderFactory resteasyProviderFactory;

    public T getObject() throws Exception {
        return this.client;
    }

    public Class<T> getObjectType() {
        return this.serviceInterface;
    }

    public boolean isSingleton() {
        return true;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.resteasyProviderFactory == null) {
            this.resteasyProviderFactory = ResteasyProviderFactory.getInstance();
        }
        RegisterBuiltin.register((ResteasyProviderFactory)this.resteasyProviderFactory);
        ResteasyClientBuilder clientBuilder = new ResteasyClientBuilder();
        clientBuilder.providerFactory(this.resteasyProviderFactory);
        if (this.clientEngine == null) {
            this.clientEngine = this.httpClient == null ? new ApacheHttpClient4Engine() : new ApacheHttpClient4Engine(this.httpClient);
        }
        ResteasyWebTarget target = clientBuilder.httpEngine(this.clientEngine).build().target(this.baseUri);
        this.client = target.proxy(this.serviceInterface);
    }

    public Class<T> getServiceInterface() {
        return this.serviceInterface;
    }

    public void setServiceInterface(Class<T> serviceInterface) {
        this.serviceInterface = serviceInterface;
    }

    public URI getBaseUri() {
        return this.baseUri;
    }

    public void setBaseUri(URI baseUri) {
        this.baseUri = baseUri;
    }

    public HttpClient getHttpClient() {
        return this.httpClient;
    }

    public void setHttpClient(HttpClient httpClient) {
        this.httpClient = httpClient;
    }

    public ClientHttpEngine getClientEngine() {
        return this.clientEngine;
    }

    public void setClientExecutor(ClientHttpEngine clientEngine) {
        this.clientEngine = clientEngine;
    }

    public ResteasyProviderFactory getResteasyProviderFactory() {
        return this.resteasyProviderFactory;
    }

    public void setResteasyProviderFactory(ResteasyProviderFactory resteasyProviderFactory) {
        this.resteasyProviderFactory = resteasyProviderFactory;
    }
}

