/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.springmvc;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.core.MediaType;
import org.jboss.resteasy.core.ServerResponse;
import org.jboss.resteasy.core.SynchronousDispatcher;
import org.jboss.resteasy.spi.HttpRequest;
import org.jboss.resteasy.spi.HttpResponse;
import org.jboss.resteasy.springmvc.RequestUtil;
import org.jboss.resteasy.springmvc.ResteasyRequestWrapper;
import org.jboss.resteasy.springmvc.ResteasyWebHandlerTemplate;
import org.jboss.resteasy.util.MediaTypeHelper;
import org.springframework.validation.BindingResult;
import org.springframework.web.servlet.View;

public class ResteasyView
implements View {
    private MediaType contentType = null;
    private List<MediaType> potentialContentTypes = null;
    private SynchronousDispatcher dispatcher;

    public ResteasyView(String contentType, SynchronousDispatcher dispatcher) {
        this.setContentType(contentType);
        this.setDispatcher(dispatcher);
    }

    public ResteasyView() {
    }

    public SynchronousDispatcher getDispatcher() {
        return this.dispatcher;
    }

    public void setDispatcher(SynchronousDispatcher dispatcher) {
        this.dispatcher = dispatcher;
    }

    public String getContentType() {
        return this.contentType.toString();
    }

    public List<String> getPotentialContentTypes() {
        ArrayList<String> contentTypes = new ArrayList<String>(this.potentialContentTypes.size());
        for (MediaType mediaType : this.potentialContentTypes) {
            contentTypes.add(mediaType.toString());
        }
        return contentTypes;
    }

    public void setPotentialContentTypes(List<String> potentialContentTypes) {
        this.potentialContentTypes = new ArrayList<MediaType>();
        for (String type : potentialContentTypes) {
            this.potentialContentTypes.add(MediaType.valueOf((String)type));
        }
    }

    public void render(final Map model, HttpServletRequest servletRequest, HttpServletResponse servletResponse) throws Exception {
        ResteasyWebHandlerTemplate<Void> template = new ResteasyWebHandlerTemplate<Void>(this.dispatcher.getProviderFactory()){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected Void handle(ResteasyRequestWrapper requestWrapper, HttpResponse response) throws Exception {
                HttpRequest httpRequest = requestWrapper.getHttpRequest();
                ResteasyView.this.dispatcher.pushContextObjects(httpRequest, response);
                try {
                    try {
                        MediaType resolvedContentType = ResteasyView.this.resolveContentType(httpRequest, httpRequest.getHttpHeaders().getMediaType());
                        ServerResponse responseInvoker = ResteasyView.this.getResponse(model, resolvedContentType);
                        if (responseInvoker != null) {
                            responseInvoker.writeTo(httpRequest, response, ResteasyView.this.dispatcher.getProviderFactory());
                        }
                    }
                    catch (Exception e) {
                        ResteasyView.this.dispatcher.handleWriteResponseException(httpRequest, response, e);
                    }
                    Void void_ = null;
                    return void_;
                }
                finally {
                    ResteasyView.this.dispatcher.clearContextData();
                }
            }
        };
        ResteasyRequestWrapper requestWrapper = RequestUtil.getRequestWrapper(servletRequest);
        template.handle(requestWrapper, servletResponse);
    }

    private MediaType resolveContentType(HttpRequest jaxrsRequest, MediaType mt) {
        if (mt == null || "*".equals(mt.getType())) {
            List acceptableMediaTypes = jaxrsRequest.getHttpHeaders().getAcceptableMediaTypes();
            if (this.contentType != null && this.isAcceptable(acceptableMediaTypes, this.contentType)) {
                return this.contentType;
            }
            return MediaTypeHelper.getBestMatch(this.potentialContentTypes, (List)acceptableMediaTypes);
        }
        return mt;
    }

    private boolean isAcceptable(List<MediaType> acceptableMediaTypes, MediaType potentialContentType) {
        boolean isAcceptable = false;
        for (MediaType acceptableMediaType : acceptableMediaTypes) {
            if (!acceptableMediaType.isCompatible(potentialContentType)) continue;
            isAcceptable = true;
            break;
        }
        return isAcceptable;
    }

    protected ServerResponse getResponse(Map model, MediaType mt) {
        Collection modelValues = model.values();
        for (Object value : modelValues) {
            if (!(value instanceof ServerResponse)) continue;
            return (ServerResponse)value;
        }
        if (model.size() == 1) {
            return this.createResponse(modelValues.iterator().next(), mt);
        }
        if (model.size() == 2) {
            for (Object value : modelValues) {
                if (value instanceof BindingResult) continue;
                return this.createResponse(value, mt);
            }
        }
        return null;
    }

    private ServerResponse createResponse(Object value, MediaType contentType) {
        ServerResponse responseImpl = new ServerResponse();
        responseImpl.setEntity(value);
        if (contentType != null) {
            responseImpl.getMetadata().putSingle((Object)"Content-Type", (Object)contentType);
        }
        return responseImpl;
    }

    public void setContentType(String contentType) {
        this.contentType = MediaType.valueOf((String)contentType);
    }
}

