/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.spring.web;

import javax.ws.rs.ConstrainedTo;
import javax.ws.rs.RuntimeType;
import javax.ws.rs.container.DynamicFeature;
import javax.ws.rs.container.ResourceInfo;
import javax.ws.rs.core.FeatureContext;
import javax.ws.rs.ext.Provider;
import org.jboss.resteasy.spring.web.ResponseStatusContainerResponseFilter;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.ResponseStatus;

@Provider
@ConstrainedTo(value=RuntimeType.SERVER)
public class ResponseStatusFeature
implements DynamicFeature {
    public void configure(ResourceInfo resourceInfo, FeatureContext context) {
        ResponseStatus responseStatus = resourceInfo.getResourceMethod().getAnnotation(ResponseStatus.class);
        if (responseStatus == null) {
            return;
        }
        HttpStatus httpStatus = responseStatus.code();
        if (httpStatus == HttpStatus.INTERNAL_SERVER_ERROR) {
            httpStatus = responseStatus.value();
        }
        context.register((Object)new ResponseStatusContainerResponseFilter(httpStatus.value()));
    }
}

