/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.plugins.servlet;

import java.util.HashSet;
import java.util.Set;
import javax.servlet.ServletContainerInitializer;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRegistration;
import javax.servlet.annotation.HandlesTypes;
import javax.ws.rs.ApplicationPath;
import javax.ws.rs.Path;
import javax.ws.rs.core.Application;
import javax.ws.rs.ext.Provider;
import org.jboss.resteasy.core.AsynchronousDispatcher;
import org.jboss.resteasy.logging.Logger;
import org.jboss.resteasy.plugins.server.servlet.HttpServlet30Dispatcher;
import org.jboss.resteasy.spi.NotImplementedYetException;

@HandlesTypes(value={Application.class, Path.class, Provider.class})
public class ResteasyServletInitializer
implements ServletContainerInitializer {
    static final Logger logger = Logger.getLogger(ResteasyServletInitializer.class);
    static final Set<String> ignoredPackages = new HashSet<String>();

    public void onStartup(Set<Class<?>> classes, ServletContext servletContext) throws ServletException {
        if (classes == null || classes.size() == 0) {
            return;
        }
        for (ServletRegistration reg : servletContext.getServletRegistrations().values()) {
            if (reg.getInitParameter("javax.ws.rs.Application") == null) continue;
            return;
        }
        HashSet appClasses = new HashSet();
        HashSet providers = new HashSet();
        HashSet resources = new HashSet();
        for (Class<?> clazz : classes) {
            if (ignoredPackages.contains(clazz.getPackage().getName())) continue;
            if (clazz.isAnnotationPresent(Path.class)) {
                resources.add(clazz);
                continue;
            }
            if (clazz.isAnnotationPresent(Provider.class)) {
                providers.add(clazz);
                continue;
            }
            appClasses.add(clazz);
        }
        if (appClasses.size() == 0 && resources.size() == 0) {
            return;
        }
        if (appClasses.size() == 0) {
            return;
        }
        for (Class<Object> clazz : appClasses) {
            this.register(clazz, providers, resources, servletContext);
        }
    }

    protected void handleNoApplicationClass(Set<Class<?>> providers, Set<Class<?>> resources, ServletContext servletContext) {
        ServletRegistration defaultApp = null;
        for (ServletRegistration reg : servletContext.getServletRegistrations().values()) {
            if (!reg.getName().equals(Application.class.getName())) continue;
            defaultApp = reg;
        }
        if (defaultApp == null) {
            return;
        }
        throw new NotImplementedYetException("Default Application class not implemented yet");
    }

    protected void register(Class<?> applicationClass, Set<Class<?>> providers, Set<Class<?>> resources, ServletContext servletContext) {
        StringBuilder builder;
        ApplicationPath path = applicationClass.getAnnotation(ApplicationPath.class);
        if (path == null) {
            return;
        }
        ServletRegistration.Dynamic reg = servletContext.addServlet(applicationClass.getName(), HttpServlet30Dispatcher.class);
        reg.setLoadOnStartup(1);
        reg.setAsyncSupported(true);
        reg.setInitParameter("javax.ws.rs.Application", applicationClass.getName());
        if (path != null) {
            String prefix;
            String mapping = path.value();
            if (!mapping.startsWith("/")) {
                mapping = "/" + mapping;
            }
            if (!(prefix = mapping).equals("/") && prefix.endsWith("/")) {
                prefix = prefix.substring(0, prefix.length() - 1);
            }
            mapping = mapping.endsWith("/") ? mapping + "*" : mapping + "/*";
            reg.setInitParameter("resteasy.servlet.mapping.prefix", prefix);
            reg.addMapping(new String[]{mapping});
        }
        if (resources.size() > 0) {
            builder = new StringBuilder();
            boolean first = true;
            for (Class<?> resource : resources) {
                if (first) {
                    first = false;
                } else {
                    builder.append(",");
                }
                builder.append(resource.getName());
            }
            reg.setInitParameter("resteasy.scanned.resources", builder.toString());
        }
        if (providers.size() > 0) {
            builder = new StringBuilder();
            boolean first = true;
            for (Class<?> provider : providers) {
                if (first) {
                    first = false;
                } else {
                    builder.append(",");
                }
                builder.append(provider.getName());
            }
            reg.setInitParameter("resteasy.scanned.providers", builder.toString());
        }
    }

    static {
        ignoredPackages.add(AsynchronousDispatcher.class.getPackage().getName());
    }
}

