/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.rxjava2.propagation;

import io.reactivex.Observable;
import io.reactivex.Observer;
import io.reactivex.disposables.Disposable;
import io.reactivex.functions.BiFunction;
import java.util.concurrent.Executor;
import org.jboss.resteasy.concurrent.ContextualExecutors;

class ContextPropagatorOnObservableCreateAction
implements BiFunction<Observable, Observer, Observer> {
    ContextPropagatorOnObservableCreateAction() {
    }

    public Observer apply(Observable observable, Observer observer) throws Exception {
        return new ContextCapturerObservable(observable, observer, ContextualExecutors.executor());
    }

    private static class ContextCapturerObservable<T>
    implements Observer<T> {
        private final Observer<T> source;
        private final Executor contextExecutor;

        private ContextCapturerObservable(Observable<T> observable, Observer<T> observer, Executor contextExecutor) {
            this.source = observer;
            this.contextExecutor = contextExecutor;
        }

        public void onComplete() {
            this.contextExecutor.execute(() -> this.source.onComplete());
        }

        public void onError(Throwable t) {
            this.contextExecutor.execute(() -> this.source.onError(t));
        }

        public void onNext(T v) {
            this.contextExecutor.execute(() -> this.source.onNext(v));
        }

        public void onSubscribe(Disposable d) {
            this.contextExecutor.execute(() -> this.source.onSubscribe(d));
        }
    }
}

