/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.plugins.providers.jsonb;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Type;
import javax.json.bind.Jsonb;
import javax.json.bind.JsonbBuilder;
import javax.json.bind.JsonbException;

class ManagedJsonb
implements Jsonb {
    private final Object lock = new Object();
    private final boolean unmanaged;
    private Jsonb delegate;

    ManagedJsonb(Jsonb delegate) {
        this.delegate = delegate;
        this.unmanaged = delegate == null;
    }

    public <T> T fromJson(String str, Class<T> type) throws JsonbException {
        return (T)this.getDelegate().fromJson(str, type);
    }

    public <T> T fromJson(String str, Type runtimeType) throws JsonbException {
        return (T)this.getDelegate().fromJson(str, runtimeType);
    }

    public <T> T fromJson(Reader reader, Class<T> type) throws JsonbException {
        return (T)this.getDelegate().fromJson(reader, type);
    }

    public <T> T fromJson(Reader reader, Type runtimeType) throws JsonbException {
        return (T)this.getDelegate().fromJson(reader, runtimeType);
    }

    public <T> T fromJson(InputStream stream, Class<T> type) throws JsonbException {
        return (T)this.getDelegate().fromJson(stream, type);
    }

    public <T> T fromJson(InputStream stream, Type runtimeType) throws JsonbException {
        return (T)this.getDelegate().fromJson(stream, runtimeType);
    }

    public String toJson(Object object) throws JsonbException {
        return this.getDelegate().toJson(object);
    }

    public String toJson(Object object, Type runtimeType) throws JsonbException {
        return this.getDelegate().toJson(object, runtimeType);
    }

    public void toJson(Object object, Writer writer) throws JsonbException {
        this.getDelegate().toJson(object, writer);
    }

    public void toJson(Object object, Type runtimeType, Writer writer) throws JsonbException {
        this.getDelegate().toJson(object, runtimeType, writer);
    }

    public void toJson(Object object, OutputStream stream) throws JsonbException {
        this.getDelegate().toJson(object, stream);
    }

    public void toJson(Object object, Type runtimeType, OutputStream stream) throws JsonbException {
        this.getDelegate().toJson(object, runtimeType, stream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws Exception {
        if (this.unmanaged) {
            Object object = this.lock;
            synchronized (object) {
                if (this.delegate != null) {
                    this.delegate.close();
                    this.delegate = null;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Jsonb getDelegate() {
        Jsonb result = this.delegate;
        if (this.unmanaged) {
            Object object = this.lock;
            synchronized (object) {
                if (result == null) {
                    result = this.delegate = JsonbBuilder.create();
                }
            }
        }
        return result;
    }
}

